/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.impl.matcher;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import spectator-agent.spectator.impl.Preconditions;
import spectator-agent.spectator.impl.matcher.AnyMatcher;
import spectator-agent.spectator.impl.matcher.GreedyMatcher;
import spectator-agent.spectator.impl.matcher.Matcher;
import spectator-agent.spectator.impl.matcher.SeqMatcher;
import spectator-agent.spectator.impl.matcher.TrueMatcher;

final class ZeroOrOneMatcher
implements GreedyMatcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Matcher repeated;
    private final Matcher next;

    ZeroOrOneMatcher(Matcher repeated, Matcher next) {
        this.repeated = Preconditions.checkNotNull(repeated, "repeated");
        this.next = Preconditions.checkNotNull(next, "next");
    }

    Matcher repeated() {
        return this.repeated;
    }

    Matcher next() {
        return this.next;
    }

    @Override
    public int matches(String str, int start, int length) {
        int end = start + length;
        int pos = this.repeated.matches(str, start, end - start);
        if (pos >= start && (pos = this.next.matches(str, pos, end - pos)) >= start) {
            return pos;
        }
        return this.next.matches(str, start, end - start);
    }

    @Override
    public int minLength() {
        return this.next.minLength();
    }

    @Override
    public boolean isEndAnchored() {
        return this.next.isEndAnchored();
    }

    @Override
    public boolean alwaysMatches() {
        return this.repeated instanceof AnyMatcher && this.next instanceof TrueMatcher;
    }

    @Override
    public Matcher mergeNext(Matcher after) {
        if (after instanceof TrueMatcher) {
            return this;
        }
        Matcher m = this.next instanceof TrueMatcher ? after : SeqMatcher.create(this.next, after);
        return new ZeroOrOneMatcher(this.repeated, m);
    }

    @Override
    public Matcher rewrite(Function<Matcher, Matcher> f) {
        return f.apply(new ZeroOrOneMatcher(this.repeated.rewrite(f), this.next.rewrite(f)));
    }

    @Override
    public Matcher rewriteEnd(Function<Matcher, Matcher> f) {
        return f.apply(new ZeroOrOneMatcher(this.repeated, this.next.rewriteEnd(f)));
    }

    public String toString() {
        return "(?:" + this.repeated + ")?" + (this.next instanceof TrueMatcher ? "" : this.next.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZeroOrOneMatcher that = (ZeroOrOneMatcher)o;
        return Objects.equals(this.repeated, that.repeated) && Objects.equals(this.next, that.next);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.repeated.hashCode();
        result = 31 * result + this.next.hashCode();
        return result;
    }
}

