/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.ArrayList;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Meter;
import spectator-agent.spectator.atlas.MeasurementConsumer;

abstract class AtlasMeter
implements Meter {
    protected final Id id;
    protected final Clock clock;
    private final long ttl;
    private volatile long lastUpdated;

    AtlasMeter(Id id, Clock clock, long ttl) {
        this.id = id;
        this.clock = clock;
        this.ttl = ttl;
        this.lastUpdated = clock.wallTime();
    }

    void updateLastModTime(long now) {
        this.lastUpdated = now;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        return this.clock.wallTime() - this.lastUpdated > this.ttl;
    }

    @Override
    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        this.measure(now, (id, timestamp, value) -> ms.add(new Measurement(id, timestamp, value)));
        return ms;
    }

    abstract void measure(long var1, MeasurementConsumer var3);
}

