/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iep.config;

import com.netflix.iep.config.DynamicConfigManager;
import java.io.File;
import spectator-agent.config.Config;
import spectator-agent.config.ConfigFactory;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;

public final class ConfigManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigManager.class);
    private static final Config CONFIG = ConfigManager.load();
    private static final DynamicConfigManager DYNAMIC = DynamicConfigManager.create(CONFIG);

    public static Config get() {
        return CONFIG;
    }

    public static DynamicConfigManager dynamicConfigManager() {
        return DYNAMIC;
    }

    public static Config dynamicConfig() {
        return DYNAMIC.get();
    }

    public static Config load() {
        return ConfigManager.load(ConfigManager.pickClassLoader());
    }

    public static Config load(ClassLoader classLoader) {
        Config config = ConfigFactory.load(classLoader);
        String string = "iep-" + config.getString("netflix.iep.env.account-type") + ".conf";
        Config config2 = ConfigManager.loadConfigByName(classLoader, string);
        return ConfigManager.loadIncludes(classLoader, config2.withFallback(config).resolve());
    }

    private static ClassLoader pickClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            LOGGER.warn("Thread.currentThread().getContextClassLoader() is null, using loader for {}", (Object)ConfigManager.class.getName());
            return ConfigManager.class.getClassLoader();
        }
        return classLoader;
    }

    private static Config loadConfigByName(ClassLoader classLoader, String string) {
        LOGGER.debug("loading config {}", (Object)string);
        if (string.startsWith("file:")) {
            File file = new File(string.substring("file:".length()));
            return ConfigFactory.parseFile(file);
        }
        return ConfigFactory.parseResources(classLoader, string);
    }

    private static Config loadIncludes(ClassLoader classLoader, Config config) {
        Config config2 = config;
        for (String string : config.getStringList("netflix.iep.include")) {
            Config config3 = ConfigManager.loadConfigByName(classLoader, string);
            config2 = config3.withFallback(config2);
        }
        return config2.resolve();
    }
}

