/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.impl.matcher;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import spectator-agent.spectator.impl.matcher.Matcher;

final class RepeatMatcher
implements Matcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Matcher repeated;
    private final int min;
    private final int max;

    RepeatMatcher(Matcher repeated, int min, int max) {
        this.repeated = repeated;
        this.min = min;
        this.max = max;
    }

    @Override
    public int matches(String str, int start, int length) {
        int end = start + length;
        int pos = start;
        for (int numMatches = 0; pos >= 0 && numMatches < this.max; ++numMatches) {
            int p = this.repeated.matches(str, pos, end - pos);
            if (p >= 0) {
                pos = p;
                continue;
            }
            return numMatches >= this.min ? pos : -1;
        }
        return pos;
    }

    @Override
    public int minLength() {
        return this.min * this.repeated.minLength();
    }

    @Override
    public Matcher rewrite(Function<Matcher, Matcher> f) {
        return new RepeatMatcher(f.apply(this.repeated), this.min, this.max);
    }

    @Override
    public Matcher rewriteEnd(Function<Matcher, Matcher> f) {
        return new RepeatMatcher(f.apply(this.repeated), this.min, this.max);
    }

    public String toString() {
        return this.min == this.max ? this.repeated + "{" + this.min + "}" : this.repeated + "{" + this.min + "," + this.max + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepeatMatcher that = (RepeatMatcher)o;
        return this.min == that.min && this.max == that.max && Objects.equals(this.repeated, that.repeated);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.repeated.hashCode();
        result = 31 * result + this.min;
        result = 31 * result + this.max;
        return result;
    }
}

