/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.impl.matcher;

import java.io.Serializable;
import java.util.Objects;
import spectator-agent.spectator.impl.matcher.Matcher;
import spectator-agent.spectator.impl.matcher.PatternUtils;

final class CharSeqMatcher
implements Matcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String pattern;
    private final boolean ignoreCase;

    CharSeqMatcher(char pattern) {
        this(String.valueOf(pattern));
    }

    CharSeqMatcher(String pattern) {
        this(pattern, false);
    }

    CharSeqMatcher(String pattern, boolean ignoreCase) {
        this.pattern = pattern;
        this.ignoreCase = ignoreCase;
    }

    String pattern() {
        return this.pattern;
    }

    @Override
    public int matches(String str, int start, int length) {
        int plength = this.pattern.length();
        boolean matched = this.ignoreCase ? str.regionMatches(true, start, this.pattern, 0, plength) : str.startsWith(this.pattern, start);
        return matched ? start + plength : -1;
    }

    @Override
    public int minLength() {
        return this.pattern.length();
    }

    public String toString() {
        return PatternUtils.escape(this.pattern);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharSeqMatcher that = (CharSeqMatcher)o;
        return this.ignoreCase == that.ignoreCase && Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.pattern.hashCode();
        result = 31 * result + Boolean.hashCode(this.ignoreCase);
        return result;
    }
}

