/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import spectator-agent.spectator.atlas.impl.Query;
import spectator-agent.spectator.atlas.impl.TagsValuePair;
import spectator-agent.spectator.impl.Preconditions;

public interface DataExpr {
    public Query query();

    public Aggregator aggregator(Map<String, String> var1, boolean var2);

    default public Aggregator aggregator() {
        return this.aggregator(this.query().exactTags(), true);
    }

    default public Iterable<TagsValuePair> eval(Iterable<TagsValuePair> input) {
        Aggregator aggr = this.aggregator();
        for (TagsValuePair p : input) {
            aggr.update(p);
        }
        return aggr.result();
    }

    public static final class KeepRollup
    implements DataExpr {
        private final AggregateFunction af;
        private final Set<String> keys;

        KeepRollup(AggregateFunction af, List<String> keys) {
            this.af = af;
            this.keys = new HashSet<String>(keys);
            this.keys.add("name");
        }

        @Override
        public Query query() {
            return this.af.query();
        }

        @Override
        public Aggregator aggregator(Map<String, String> ignored, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private final Map<Map<String, String>, Aggregator> aggrs = new HashMap<Map<String, String>, Aggregator>();

                @Override
                public void update(TagsValuePair p) {
                    Map<String, String> tags = p.tags();
                    if (!shouldCheckQuery || af.query().matches(tags)) {
                        Map<String, String> newTags = tags.entrySet().stream().filter(e -> keys.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                        this.aggrs.computeIfAbsent(newTags, ks -> af.aggregator((Map<String, String>)ks, false)).update(p);
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.aggrs.values().stream().flatMap(a -> StreamSupport.stream(a.result().spliterator(), false)).collect(Collectors.toList());
                }
            };
        }

        @Override
        public Aggregator aggregator() {
            return this.aggregator(null, true);
        }

        public String toString() {
            String keyList = String.join((CharSequence)",", this.keys);
            return this.af.toString() + ",(," + keyList + ",),:rollup-keep";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof KeepRollup)) {
                return false;
            }
            KeepRollup other = (KeepRollup)obj;
            return this.af.equals(other.af) && this.keys.equals(other.keys);
        }

        public int hashCode() {
            int result = this.af.hashCode();
            result = 31 * result + this.keys.hashCode();
            result = 31 * result + ":by".hashCode();
            return result;
        }
    }

    public static final class DropRollup
    implements DataExpr {
        private final AggregateFunction af;
        private final List<String> keys;

        DropRollup(AggregateFunction af, List<String> keys) {
            Preconditions.checkArg(!keys.contains("name"), "name is required and cannot be dropped");
            this.af = af;
            this.keys = keys;
        }

        @Override
        public Query query() {
            return this.af.query();
        }

        @Override
        public Aggregator aggregator(Map<String, String> ignored, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private final Map<Map<String, String>, Aggregator> aggrs = new HashMap<Map<String, String>, Aggregator>();

                @Override
                public void update(TagsValuePair p) {
                    HashMap<String, String> tags = new HashMap<String, String>(p.tags());
                    if (!shouldCheckQuery || af.query().matches(tags)) {
                        for (String k : keys) {
                            tags.remove(k);
                        }
                        this.aggrs.computeIfAbsent(tags, ks -> af.aggregator((Map<String, String>)ks, false)).update(p);
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.aggrs.values().stream().flatMap(a -> StreamSupport.stream(a.result().spliterator(), false)).collect(Collectors.toList());
                }
            };
        }

        @Override
        public Aggregator aggregator() {
            return this.aggregator(null, true);
        }

        public String toString() {
            String keyList = String.join((CharSequence)",", this.keys);
            return this.af.toString() + ",(," + keyList + ",),:rollup-drop";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DropRollup)) {
                return false;
            }
            DropRollup other = (DropRollup)obj;
            return this.af.equals(other.af) && this.keys.equals(other.keys);
        }

        public int hashCode() {
            int result = this.af.hashCode();
            result = 31 * result + this.keys.hashCode();
            result = 31 * result + ":by".hashCode();
            return result;
        }
    }

    public static final class GroupBy
    implements DataExpr {
        private final AggregateFunction af;
        private final List<String> keys;

        GroupBy(AggregateFunction af, List<String> keys) {
            Preconditions.checkArg(!keys.isEmpty(), "key list for group by cannot be empty");
            this.af = af;
            this.keys = keys;
        }

        private Map<String, String> keyTags(Map<String, String> tags) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (String k : this.keys) {
                String v = tags.get(k);
                if (v == null) {
                    return null;
                }
                result.put(k, v);
            }
            return result;
        }

        @Override
        public Query query() {
            return this.af.query();
        }

        @Override
        public Aggregator aggregator(final Map<String, String> queryTags, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private final Map<Map<String, String>, Aggregator> aggrs = new HashMap<Map<String, String>, Aggregator>();

                @Override
                public void update(TagsValuePair p) {
                    Map k;
                    Map<String, String> tags = p.tags();
                    if ((!shouldCheckQuery || af.query().matches(tags)) && (k = this.keyTags(tags)) != null) {
                        k.putAll(queryTags);
                        this.aggrs.computeIfAbsent(k, ks -> af.aggregator((Map<String, String>)ks, false)).update(p);
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.aggrs.values().stream().flatMap(a -> StreamSupport.stream(a.result().spliterator(), false)).collect(Collectors.toList());
                }
            };
        }

        public String toString() {
            String keyList = String.join((CharSequence)",", this.keys);
            return this.af.toString() + ",(," + keyList + ",),:by";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GroupBy)) {
                return false;
            }
            GroupBy other = (GroupBy)obj;
            return this.af.equals(other.af) && this.keys.equals(other.keys);
        }

        public int hashCode() {
            int result = this.af.hashCode();
            result = 31 * result + this.keys.hashCode();
            result = 31 * result + ":by".hashCode();
            return result;
        }
    }

    public static final class Count
    implements AggregateFunction {
        private final Query query;

        Count(Query query) {
            this.query = query;
        }

        @Override
        public Query query() {
            return this.query;
        }

        @Override
        public Aggregator aggregator(final Map<String, String> tags, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private int aggr = 0;

                @Override
                public void update(TagsValuePair p) {
                    if (!shouldCheckQuery || query.matches(p.tags())) {
                        ++this.aggr;
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.aggr > 0 ? Collections.singletonList(new TagsValuePair(tags, this.aggr)) : Collections.emptyList();
                }
            };
        }

        public String toString() {
            return this.query.toString() + ",:count";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Count)) {
                return false;
            }
            Count other = (Count)obj;
            return this.query.equals(other.query);
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + ":count".hashCode();
            return result;
        }
    }

    public static final class Max
    implements AggregateFunction {
        private final Query query;

        Max(Query query) {
            this.query = query;
        }

        @Override
        public Query query() {
            return this.query;
        }

        @Override
        public Aggregator aggregator(final Map<String, String> tags, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private double aggr = -1.7976931348623157E308;
                private int count = 0;

                @Override
                public void update(TagsValuePair p) {
                    if ((!shouldCheckQuery || query.matches(p.tags())) && p.value() > this.aggr) {
                        this.aggr = p.value();
                        ++this.count;
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.count > 0 ? Collections.singletonList(new TagsValuePair(tags, this.aggr)) : Collections.emptyList();
                }
            };
        }

        public String toString() {
            return this.query.toString() + ",:max";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Max)) {
                return false;
            }
            Max other = (Max)obj;
            return this.query.equals(other.query);
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + ":max".hashCode();
            return result;
        }
    }

    public static final class Min
    implements AggregateFunction {
        private final Query query;

        Min(Query query) {
            this.query = query;
        }

        @Override
        public Query query() {
            return this.query;
        }

        @Override
        public Aggregator aggregator(final Map<String, String> tags, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private double aggr = Double.MAX_VALUE;
                private int count = 0;

                @Override
                public void update(TagsValuePair p) {
                    if ((!shouldCheckQuery || query.matches(p.tags())) && p.value() < this.aggr) {
                        this.aggr = p.value();
                        ++this.count;
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.count > 0 ? Collections.singletonList(new TagsValuePair(tags, this.aggr)) : Collections.emptyList();
                }
            };
        }

        public String toString() {
            return this.query.toString() + ",:min";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Min)) {
                return false;
            }
            Min other = (Min)obj;
            return this.query.equals(other.query);
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + ":min".hashCode();
            return result;
        }
    }

    public static final class Sum
    implements AggregateFunction {
        private final Query query;

        Sum(Query query) {
            this.query = query;
        }

        @Override
        public Query query() {
            return this.query;
        }

        @Override
        public Aggregator aggregator(final Map<String, String> tags, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private double aggr = 0.0;
                private int count = 0;

                @Override
                public void update(TagsValuePair p) {
                    if (!shouldCheckQuery || query.matches(p.tags())) {
                        this.aggr += p.value();
                        ++this.count;
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.count > 0 ? Collections.singletonList(new TagsValuePair(tags, this.aggr)) : Collections.emptyList();
                }
            };
        }

        public String toString() {
            return this.query.toString() + ",:sum";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Sum)) {
                return false;
            }
            Sum other = (Sum)obj;
            return this.query.equals(other.query);
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + ":sum".hashCode();
            return result;
        }
    }

    public static interface AggregateFunction
    extends DataExpr {
    }

    public static final class All
    implements DataExpr {
        private final Query query;

        All(Query query) {
            this.query = query;
        }

        @Override
        public Query query() {
            return this.query;
        }

        @Override
        public Aggregator aggregator(Map<String, String> ignored, final boolean shouldCheckQuery) {
            return new Aggregator(){
                private final List<TagsValuePair> pairs = new ArrayList<TagsValuePair>();

                @Override
                public void update(TagsValuePair p) {
                    Map<String, String> tags = p.tags();
                    if (!shouldCheckQuery || query.matches(tags)) {
                        this.pairs.add(new TagsValuePair(tags, p.value()));
                    }
                }

                @Override
                public Iterable<TagsValuePair> result() {
                    return this.pairs;
                }
            };
        }

        @Override
        public Aggregator aggregator() {
            return this.aggregator(null, true);
        }

        public String toString() {
            return this.query.toString() + ",:all";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof All)) {
                return false;
            }
            All other = (All)obj;
            return this.query.equals(other.query);
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + ":all".hashCode();
            return result;
        }
    }

    public static interface Aggregator {
        public void update(TagsValuePair var1);

        public Iterable<TagsValuePair> result();
    }
}

