/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import spectator-agent.spectator.api.ArrayTagSet;
import spectator-agent.spectator.api.Tag;

public interface TagList
extends Iterable<Tag>,
Comparable<TagList> {
    public String getKey(int var1);

    public String getValue(int var1);

    public int size();

    default public Tag getTag(int i) {
        return Tag.of(this.getKey(i), this.getValue(i));
    }

    default public TagList filter(BiPredicate<String, String> predicate) {
        int n = this.size();
        ArrayList<Tag> result = new ArrayList<Tag>(n);
        for (int i = 0; i < n; ++i) {
            String v;
            String k = this.getKey(i);
            if (!predicate.test(k, v = this.getValue(i))) continue;
            result.add(Tag.of(k, v));
        }
        return ArrayTagSet.create(result);
    }

    default public TagList filterByKey(Predicate<String> predicate) {
        return this.filter((k, v) -> predicate.test((String)k));
    }

    default public void forEach(BiConsumer<String, String> consumer) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            consumer.accept(this.getKey(i), this.getValue(i));
        }
    }

    @Override
    default public Iterator<Tag> iterator() {
        final int length = this.size();
        return new Iterator<Tag>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < length;
            }

            @Override
            public Tag next() {
                if (this.i >= length) {
                    throw new NoSuchElementException("next called after end of iterator");
                }
                return TagList.this.getTag(this.i++);
            }
        };
    }

    @Override
    default public int compareTo(TagList other) {
        if (this == other) {
            return 0;
        }
        int n = Math.min(this.size(), other.size());
        for (int i = 0; i < n; ++i) {
            int cmp = this.getKey(i).compareTo(other.getKey(i));
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getValue(i).compareTo(other.getValue(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return this.size() - other.size();
    }
}

