/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.json.jackson.databind.deser.std;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import spectator-agent.json.jackson.databind.JsonDeserializer;
import spectator-agent.json.jackson.databind.deser.std.AtomicBooleanDeserializer;
import spectator-agent.json.jackson.databind.deser.std.AtomicIntegerDeserializer;
import spectator-agent.json.jackson.databind.deser.std.AtomicLongDeserializer;
import spectator-agent.json.jackson.databind.deser.std.ByteBufferDeserializer;
import spectator-agent.json.jackson.databind.deser.std.FromStringDeserializer;
import spectator-agent.json.jackson.databind.deser.std.NullifyingDeserializer;
import spectator-agent.json.jackson.databind.deser.std.StackTraceElementDeserializer;
import spectator-agent.json.jackson.databind.deser.std.UUIDDeserializer;

public class JdkDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> rawType, String clsName) {
        if (_classNames.contains(clsName)) {
            FromStringDeserializer<?> d = FromStringDeserializer.findDeserializer(rawType);
            if (d != null) {
                return d;
            }
            if (rawType == UUID.class) {
                return new UUIDDeserializer();
            }
            if (rawType == StackTraceElement.class) {
                return new StackTraceElementDeserializer();
            }
            if (rawType == AtomicBoolean.class) {
                return new AtomicBooleanDeserializer();
            }
            if (rawType == AtomicInteger.class) {
                return new AtomicIntegerDeserializer();
            }
            if (rawType == AtomicLong.class) {
                return new AtomicLongDeserializer();
            }
            if (rawType == ByteBuffer.class) {
                return new ByteBufferDeserializer();
            }
            if (rawType == Void.class) {
                return NullifyingDeserializer.instance;
            }
        }
        return null;
    }

    public static boolean hasDeserializerFor(Class<?> rawType) {
        return _classNames.contains(rawType.getName());
    }

    static {
        Class[] types;
        _classNames = new HashSet();
        for (Class clazz : types = new Class[]{UUID.class, AtomicBoolean.class, AtomicInteger.class, AtomicLong.class, StackTraceElement.class, ByteBuffer.class, Void.class}) {
            _classNames.add(clazz.getName());
        }
        for (Class clazz : FromStringDeserializer.types()) {
            _classNames.add(clazz.getName());
        }
    }
}

