/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import java.util.ArrayList;
import java.util.Collection;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Meter;

class CompositeMeter<T extends Meter>
implements Meter {
    protected final Id id;
    protected final Collection<T> meters;

    CompositeMeter(Id id, Collection<T> meters) {
        this.id = id;
        this.meters = meters;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public boolean hasExpired() {
        for (Meter m : this.meters) {
            if (m == null || m.hasExpired()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        for (Meter m : this.meters) {
            if (m == null) continue;
            for (Measurement measurement : m.measure()) {
                ms.add(measurement);
            }
        }
        return ms;
    }
}

