/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iep.config;

import com.netflix.iep.config.ListenerUtils;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import spectator-agent.config.Config;
import spectator-agent.config.ConfigMemorySize;

@FunctionalInterface
public interface ConfigListener {
    public static ConfigListener forPath(String string, Consumer<Config> consumer) {
        return (config, config2) -> {
            Config config3;
            Config config4 = string == null ? config : ListenerUtils.getConfig(config, string);
            Config config5 = config3 = string == null ? config2 : ListenerUtils.getConfig(config2, string);
            if (ListenerUtils.hasChanged(config4, config3)) {
                consumer.accept(config3);
            }
        };
    }

    public static ConfigListener forConfig(String string, Consumer<Config> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getConfig);
    }

    public static ConfigListener forConfigList(String string, Consumer<List<? extends Config>> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getConfigList);
    }

    public static ConfigListener forString(String string, Consumer<String> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getString);
    }

    public static ConfigListener forStringList(String string, Consumer<List<String>> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getStringList);
    }

    public static ConfigListener forBoolean(String string, Consumer<Boolean> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getBoolean);
    }

    public static ConfigListener forBooleanList(String string, Consumer<List<Boolean>> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getBooleanList);
    }

    public static ConfigListener forInt(String string, Consumer<Integer> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getInt);
    }

    public static ConfigListener forIntList(String string, Consumer<List<Integer>> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getIntList);
    }

    public static ConfigListener forLong(String string, Consumer<Long> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getLong);
    }

    public static ConfigListener forLongList(String string, Consumer<List<Long>> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getLongList);
    }

    public static ConfigListener forBytes(String string, Consumer<Long> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getBytes);
    }

    public static ConfigListener forBytesList(String string, Consumer<List<Long>> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getBytesList);
    }

    public static ConfigListener forMemorySize(String string, Consumer<ConfigMemorySize> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getMemorySize);
    }

    public static ConfigListener forMemorySizeList(String string, Consumer<List<ConfigMemorySize>> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getMemorySizeList);
    }

    public static ConfigListener forDouble(String string, Consumer<Double> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getDouble);
    }

    public static ConfigListener forDoubleList(String string, Consumer<List<Double>> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getDoubleList);
    }

    public static ConfigListener forNumber(String string, Consumer<Number> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getNumber);
    }

    public static ConfigListener forNumberList(String string, Consumer<List<Number>> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getNumberList);
    }

    public static ConfigListener forDuration(String string, Consumer<Duration> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getDuration);
    }

    public static ConfigListener forDurationList(String string, Consumer<List<Duration>> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getDurationList);
    }

    public static ConfigListener forPeriod(String string, Consumer<Period> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getPeriod);
    }

    public static ConfigListener forTemporal(String string, Consumer<TemporalAmount> consumer) {
        return ConfigListener.forConfigEntry(string, consumer, Config::getTemporal);
    }

    public static <T> ConfigListener forConfigEntry(String string, Consumer<T> consumer, BiFunction<Config, String, T> biFunction) {
        if (string == null) {
            throw new NullPointerException("property cannot be null");
        }
        return (config, config2) -> {
            Object t;
            Object t2 = ListenerUtils.getOrNull(config, string, biFunction);
            if (ListenerUtils.hasChanged(t2, t = ListenerUtils.getOrNull(config2, string, biFunction))) {
                consumer.accept(t);
            }
        };
    }

    public void onUpdate(Config var1, Config var2);
}

