/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api.histogram;

import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.LongFunction;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.api.Utils;

public final class BucketCounter
implements DistributionSummary {
    private final Id id;
    private final LongFunction<String> f;
    private final ConcurrentHashMap<String, Counter> counters;
    private final Function<String, Counter> counterFactory;

    public static BucketCounter get(Registry registry, Id id, LongFunction<String> f) {
        return new BucketCounter(registry, id, f);
    }

    BucketCounter(Registry registry, Id id, LongFunction<String> f) {
        this.id = id;
        this.f = f;
        this.counters = new ConcurrentHashMap();
        this.counterFactory = k -> registry.counter(id.withTag("bucket", (String)k));
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void record(long amount) {
        this.counter(this.f.apply(amount)).increment();
    }

    Counter counter(String bucket) {
        return Utils.computeIfAbsent(this.counters, bucket, this.counterFactory);
    }

    @Override
    public long count() {
        return 0L;
    }

    @Override
    public long totalAmount() {
        return 0L;
    }
}

