/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class EvalPayload {
    private final long timestamp;
    private final List<Metric> metrics;
    private final List<Message> messages;

    public EvalPayload(long timestamp, List<Metric> metrics, List<Message> messages) {
        this.timestamp = timestamp;
        this.metrics = metrics;
        this.messages = messages;
    }

    public EvalPayload(long timestamp, List<Metric> metrics) {
        this(timestamp, metrics, Collections.emptyList());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvalPayload payload = (EvalPayload)o;
        return this.timestamp == payload.timestamp && this.metrics.equals(payload.metrics) && this.messages.equals(payload.messages);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.metrics.hashCode();
        result = 31 * result + this.messages.hashCode();
        return result;
    }

    public String toString() {
        return "EvalPayload(timestamp=" + this.timestamp + ", metrics=" + this.metrics + ", messages=" + this.messages + ")";
    }

    public static enum MessageType {
        info,
        warn,
        error;

    }

    public static final class DiagnosticMessage {
        private final MessageType type;
        private final String message;

        public DiagnosticMessage(MessageType type, String message) {
            this.type = type;
            this.message = message;
        }

        public MessageType getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiagnosticMessage msg = (DiagnosticMessage)o;
            return this.type == msg.type && this.message.equals(msg.message);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.message.hashCode();
            return result;
        }

        public String toString() {
            return "DiagnosticMessage(type=" + (Object)((Object)this.type) + ", message=" + this.message + ")";
        }
    }

    public static final class Message {
        private final String id;
        private final DiagnosticMessage message;

        public Message(String id, DiagnosticMessage message) {
            this.id = id;
            this.message = message;
        }

        public String getId() {
            return this.id;
        }

        public DiagnosticMessage getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message msg = (Message)o;
            return this.id.equals(msg.id) && this.message.equals(msg.message);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.message.hashCode();
            return result;
        }

        public String toString() {
            return "Message(id=" + this.id + ", message=" + this.message + ")";
        }
    }

    public static final class Metric {
        private final String id;
        private final Map<String, String> tags;
        private final double value;

        public Metric(String id, Map<String, String> tags, double value) {
            this.id = id;
            this.tags = tags;
            this.value = value;
        }

        public String getId() {
            return this.id;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public double getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Metric metric = (Metric)o;
            return Double.compare(metric.value, this.value) == 0 && this.id.equals(metric.id) && this.tags.equals(metric.tags);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.tags.hashCode();
            long temp = Double.doubleToLongBits(this.value);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public String toString() {
            return "Metric(id=" + this.id + ", tags=" + this.tags + ", value=" + this.value + ")";
        }
    }
}

