/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.api.Timer;
import spectator-agent.spectator.atlas.AtlasMeter;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.impl.StepDouble;
import spectator-agent.spectator.impl.StepLong;
import spectator-agent.spectator.impl.StepValue;

class AtlasTimer
extends AtlasMeter
implements Timer {
    private final StepLong count;
    private final StepDouble total;
    private final StepDouble totalOfSquares;
    private final StepLong max;
    private final Id[] stats;

    AtlasTimer(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.count = new StepLong(0L, clock, step);
        this.total = new StepDouble(0.0, clock, step);
        this.totalOfSquares = new StepDouble(0.0, clock, step);
        this.max = new StepLong(0L, clock, step);
        this.stats = new Id[]{id.withTags(DsType.rate, Statistic.count), id.withTags(DsType.rate, Statistic.totalTime), id.withTags(DsType.rate, Statistic.totalOfSquares), id.withTags(DsType.gauge, Statistic.max)};
    }

    @Override
    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>(4);
        ms.add(this.newMeasurement(this.stats[0], this.count, 1.0));
        ms.add(this.newMeasurement(this.stats[1], this.total, 1.0E-9));
        ms.add(this.newMeasurement(this.stats[2], this.totalOfSquares, 1.0E-18));
        ms.add(this.newMaxMeasurement(this.stats[3], this.max));
        return ms;
    }

    private Measurement newMeasurement(Id mid, StepValue v, double f) {
        double rate = v.pollAsRate() * f;
        long timestamp = v.timestamp();
        return new Measurement(mid, timestamp, rate);
    }

    private Measurement newMaxMeasurement(Id mid, StepLong v) {
        double maxValue = (double)v.poll() / 1.0E9;
        long timestamp = v.timestamp();
        return new Measurement(mid, timestamp, maxValue);
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.count.getCurrent().incrementAndGet();
        if (amount > 0L) {
            long nanos = unit.toNanos(amount);
            this.total.getCurrent().addAndGet(nanos);
            this.totalOfSquares.getCurrent().addAndGet((double)nanos * (double)nanos);
            this.updateMax(this.max.getCurrent(), nanos);
        }
        this.updateLastModTime();
    }

    private void updateMax(AtomicLong maxValue, long v) {
        long p = maxValue.get();
        while (v > p && !maxValue.compareAndSet(p, v)) {
            p = maxValue.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Callable<T> f) throws Exception {
        long start = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            this.record(this.clock.monotonicTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long start = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            this.record(this.clock.monotonicTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long count() {
        return this.count.poll();
    }

    @Override
    public long totalTime() {
        return (long)this.total.poll();
    }
}

