/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api.patterns;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Utils;

public final class CardinalityLimiters {
    private static final long REFRESH_INTERVAL = 600000L;
    private static final int MAX_LIMIT = 100;
    public static final String OTHERS = "--others--";
    public static final String AUTO_ROLLUP = "--auto-rollup--";
    private static final Comparator<Map.Entry<String, AtomicLong>> FREQUENT_ENTRY_COMPARATOR = (a, b) -> {
        int countCmp = Long.compareUnsigned(((AtomicLong)b.getValue()).get(), ((AtomicLong)a.getValue()).get());
        return countCmp != 0 ? countCmp : ((String)a.getKey()).compareTo((String)b.getKey());
    };

    private CardinalityLimiters() {
    }

    public static Function<String, String> first(int n) {
        return new FirstLimiter(Math.min(n, 100));
    }

    public static Function<String, String> mostFrequent(int n) {
        return CardinalityLimiters.mostFrequent(n, Clock.SYSTEM);
    }

    static Function<String, String> mostFrequent(int n, Clock clock) {
        return new MostFrequentLimiter(Math.min(n, 100), clock);
    }

    public static Function<String, String> rollup(int n) {
        return new RollupLimiter(n);
    }

    private static class RollupLimiter
    implements Function<String, String> {
        private final int n;
        private final Set<String> values;
        private final AtomicInteger count;
        private volatile boolean rollup;

        RollupLimiter(int n) {
            this.n = n;
            this.values = ConcurrentHashMap.newKeySet();
            this.count = new AtomicInteger();
            this.rollup = false;
        }

        @Override
        public String apply(String s) {
            if (this.rollup) {
                return CardinalityLimiters.AUTO_ROLLUP;
            }
            if (this.values.add(s) && this.count.incrementAndGet() > this.n) {
                this.rollup = true;
                this.values.clear();
                return CardinalityLimiters.AUTO_ROLLUP;
            }
            return s;
        }
    }

    private static class MostFrequentLimiter
    implements Function<String, String> {
        private static final int MAX_UPDATES = 12;
        private final ReentrantLock lock = new ReentrantLock();
        private final ConcurrentHashMap<String, AtomicLong> values = new ConcurrentHashMap();
        private final int n;
        private final Clock clock;
        private volatile Function<String, String> limiter;
        private volatile long limiterTimestamp;
        private volatile long cutoff;
        private int updatesWithHighChurn;

        MostFrequentLimiter(int n, Clock clock) {
            this.n = n;
            this.clock = clock;
            this.limiter = CardinalityLimiters.first(n);
            this.limiterTimestamp = clock.wallTime();
            this.cutoff = 0L;
            this.updatesWithHighChurn = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCutoff() {
            long now = this.clock.wallTime();
            if (now - this.limiterTimestamp > 600000L && this.values.size() > this.n) {
                this.lock.lock();
                try {
                    if (now - this.limiterTimestamp > 600000L) {
                        this.limiterTimestamp = this.clock.wallTime();
                        List sorted = this.values.entrySet().stream().sorted(FREQUENT_ENTRY_COMPARATOR).collect(Collectors.toList());
                        long maxCount = ((AtomicLong)((Map.Entry)sorted.get(0)).getValue()).get();
                        Map.Entry min = (Map.Entry)sorted.get(Math.min(this.n - 1, sorted.size() - 1));
                        String minKey = (String)min.getKey();
                        long minCount = ((AtomicLong)min.getValue()).get();
                        long delta = Math.max(minCount / 2L, 1L);
                        int numCloseToMin = (int)sorted.stream().map(e -> ((AtomicLong)e.getValue()).get()).filter(v -> Math.abs(v - minCount) <= delta).count();
                        long previousCutoff = this.cutoff;
                        if (numCloseToMin > this.n) {
                            if (maxCount - minCount <= maxCount / 2L) {
                                this.cutoff = Math.max(previousCutoff, maxCount + delta);
                                this.updatesWithHighChurn = 12;
                            } else {
                                this.cutoff = Math.max(previousCutoff, minCount + delta);
                                this.updatesWithHighChurn += this.updatesWithHighChurn >= 12 ? 0 : 1;
                            }
                            sorted.stream().skip(10L * (long)this.n).forEach(e -> this.values.remove(e.getKey()));
                            Function<String, String> newLimiter = CardinalityLimiters.first(this.n);
                            sorted.stream().limit(this.n).forEach(e -> {
                                String cfr_ignored_0 = (String)newLimiter.apply((String)e.getKey());
                            });
                            this.limiter = newLimiter;
                        } else {
                            this.cutoff = minCount - minCount / 10L;
                            this.values.entrySet().removeIf(e -> ((AtomicLong)e.getValue()).get() <= minCount && ((String)e.getKey()).compareTo(minKey) > 0);
                            this.values.values().forEach(v -> v.set(v.get() - v.get() / 10L));
                            this.updatesWithHighChurn -= this.updatesWithHighChurn > 0 ? 1 : 0;
                            if (this.updatesWithHighChurn == 0) {
                                this.limiter = CardinalityLimiters.first(this.n);
                            }
                        }
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        @Override
        public String apply(String s) {
            AtomicLong count = Utils.computeIfAbsent(this.values, s, k -> new AtomicLong(0L));
            long num = count.incrementAndGet();
            if (num >= this.cutoff) {
                this.updateCutoff();
                String v = this.limiter.apply(s);
                return num >= this.cutoff ? v : CardinalityLimiters.OTHERS;
            }
            return CardinalityLimiters.OTHERS;
        }

        public String toString() {
            String vs = this.values.entrySet().stream().filter(e -> ((AtomicLong)e.getValue()).get() >= this.cutoff).map(e -> "(" + (String)e.getKey() + "," + e.getValue() + ")").sorted().collect(Collectors.joining(","));
            return "MostFrequentLimiter(" + this.cutoff + "," + this.limiter + ",values=[" + vs + "])";
        }
    }

    private static class FirstLimiter
    implements Function<String, String> {
        private final ReentrantLock lock = new ReentrantLock();
        private final ConcurrentHashMap<String, String> values = new ConcurrentHashMap();
        private final AtomicInteger remaining;

        FirstLimiter(int n) {
            this.remaining = new AtomicInteger(n);
        }

        private void add(String s) {
            if (this.remaining.get() > 0) {
                this.lock.lock();
                try {
                    if (this.remaining.get() > 0) {
                        this.values.put(s, s);
                        this.remaining.decrementAndGet();
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        @Override
        public String apply(String s) {
            if (this.remaining.get() <= 0) {
                return this.values.getOrDefault(s, CardinalityLimiters.OTHERS);
            }
            String v = this.values.get(s);
            if (v == null) {
                this.add(s);
                v = this.values.getOrDefault(s, CardinalityLimiters.OTHERS);
            }
            return v;
        }

        public String toString() {
            String vs = this.values.keySet().stream().sorted().collect(Collectors.joining(","));
            return "FirstLimiter(" + vs + ")";
        }
    }
}

