/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.agent;

import com.netflix.spectator.agent.JmxConfig;
import com.netflix.spectator.agent.JmxData;
import com.netflix.spectator.agent.JmxMeasurementConfig;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JmxMeter
implements Meter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxMeter.class);
    private final Registry registry;
    private final JmxConfig config;
    private final Id id;

    JmxMeter(Registry registry, JmxConfig config) {
        this.registry = registry;
        this.config = config;
        this.id = registry.createId(config.getQuery().getCanonicalName());
    }

    public Id id() {
        return this.id;
    }

    public Iterable<Measurement> measure() {
        ArrayList<Measurement> ms = new ArrayList<Measurement>();
        try {
            for (JmxData data : JmxData.query(this.config.getQuery())) {
                for (JmxMeasurementConfig cfg : this.config.getMeasurements()) {
                    cfg.measure(this.registry, data, ms);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("failed to query jmx data: {}", (Object)this.config.getQuery().getCanonicalName(), (Object)e);
        }
        return ms;
    }

    public boolean hasExpired() {
        return false;
    }
}

