/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import spectator-agent.json.jackson.core.JsonFactory;
import spectator-agent.json.jackson.databind.ObjectMapper;
import spectator-agent.json.jackson.databind.module.SimpleModule;
import spectator-agent.json.jackson.dataformat.smile.SmileFactory;
import spectator-agent.spectator.api.AbstractRegistry;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.DistributionSummary;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Tag;
import spectator-agent.spectator.api.Timer;
import spectator-agent.spectator.atlas.AtlasConfig;
import spectator-agent.spectator.atlas.AtlasCounter;
import spectator-agent.spectator.atlas.AtlasDistributionSummary;
import spectator-agent.spectator.atlas.AtlasGauge;
import spectator-agent.spectator.atlas.AtlasTimer;
import spectator-agent.spectator.atlas.StepClock;
import spectator-agent.spectator.atlas.impl.EvalPayload;
import spectator-agent.spectator.atlas.impl.Evaluator;
import spectator-agent.spectator.atlas.impl.MeasurementSerializer;
import spectator-agent.spectator.atlas.impl.PublishPayload;
import spectator-agent.spectator.atlas.impl.Subscription;
import spectator-agent.spectator.atlas.impl.Subscriptions;
import spectator-agent.spectator.atlas.impl.TagsValuePair;
import spectator-agent.spectator.impl.AsciiSet;
import spectator-agent.spectator.impl.Scheduler;
import spectator-agent.spectator.sandbox.HttpClient;
import spectator-agent.spectator.sandbox.HttpResponse;

public final class AtlasRegistry
extends AbstractRegistry {
    private static final String CLOCK_SKEW_TIMER = "spectator.atlas.clockSkew";
    private final Clock clock;
    private final boolean enabled;
    private final Duration step;
    private final long stepMillis;
    private final long meterTTL;
    private final URI uri;
    private final boolean lwcEnabled;
    private final Duration configRefreshFrequency;
    private final long configTTL;
    private final URI configUri;
    private final URI evalUri;
    private final int connectTimeout;
    private final int readTimeout;
    private final int batchSize;
    private final int numThreads;
    private final Map<String, String> commonTags;
    private final AsciiSet charset;
    private final Map<String, AsciiSet> overrides;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private Scheduler scheduler;
    private final Map<Subscription, Long> subscriptions = new ConcurrentHashMap<Subscription, Long>();

    public AtlasRegistry(Clock clock, AtlasConfig config) {
        super(new StepClock(clock, config.step().toMillis()), config);
        this.clock = clock;
        this.enabled = config.enabled();
        this.step = config.step();
        this.stepMillis = this.step.toMillis();
        this.meterTTL = config.meterTTL().toMillis();
        this.uri = URI.create(config.uri());
        this.lwcEnabled = config.lwcEnabled();
        this.configRefreshFrequency = config.configRefreshFrequency();
        this.configTTL = config.configTTL().toMillis();
        this.configUri = URI.create(config.configUri());
        this.evalUri = URI.create(config.evalUri());
        this.connectTimeout = (int)config.connectTimeout().toMillis();
        this.readTimeout = (int)config.readTimeout().toMillis();
        this.batchSize = config.batchSize();
        this.numThreads = config.numThreads();
        this.commonTags = new TreeMap<String, String>(config.commonTags());
        this.charset = AsciiSet.fromPattern(config.validTagCharacters());
        this.overrides = config.validTagValueCharacters().keySet().stream().collect(Collectors.toMap(k -> k, AsciiSet::fromPattern));
        SimpleModule module = new SimpleModule().addSerializer(Measurement.class, new MeasurementSerializer(this.charset, this.overrides));
        this.jsonMapper = new ObjectMapper(new JsonFactory()).registerModule(module);
        this.smileMapper = new ObjectMapper(new SmileFactory()).registerModule(module);
    }

    public void start() {
        if (this.scheduler == null) {
            Scheduler.Options options;
            if (this.enabled || this.lwcEnabled) {
                options = new Scheduler.Options().withFrequency(Scheduler.Policy.FIXED_RATE_SKIP_IF_LONG, this.step).withInitialDelay(Duration.ofMillis(this.getInitialDelay(this.stepMillis))).withStopOnFailure(false);
                this.scheduler = new Scheduler(this, "spectator-reg-atlas", this.numThreads);
                this.scheduler.schedule(options, this::collectData);
                this.logger.info("started collecting metrics every {} reporting to {}", (Object)this.step, (Object)this.uri);
                this.logger.info("common tags: {}", (Object)this.commonTags);
            } else {
                this.logger.info("publishing is not enabled");
            }
            if (this.lwcEnabled) {
                options = new Scheduler.Options().withFrequency(Scheduler.Policy.FIXED_DELAY, this.configRefreshFrequency).withStopOnFailure(false);
                this.scheduler.schedule(options, this::fetchSubscriptions);
            } else {
                this.logger.info("subscriptions are not enabled");
            }
        } else {
            this.logger.warn("registry already started, ignoring duplicate request");
        }
    }

    long getInitialDelay(long stepSize) {
        long offset;
        long stepBoundary;
        long now = this.clock.wallTime();
        long delay = now - (stepBoundary = now / stepSize * stepSize);
        if (delay < (offset = stepSize / 10L)) {
            return delay + offset;
        }
        if (delay > stepSize - offset) {
            return stepSize - offset;
        }
        return delay;
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
            this.logger.info("stopped collecting metrics every {}ms reporting to {}", (Object)this.step, (Object)this.uri);
        } else {
            this.logger.warn("registry stopped, but was never started");
        }
    }

    private void collectData() {
        if (this.lwcEnabled) {
            try {
                this.handleSubscriptions();
            }
            catch (Exception e) {
                this.logger.warn("failed to handle subscriptions", e);
            }
        }
        if (this.enabled) {
            try {
                for (List<Measurement> batch : this.getBatches()) {
                    PublishPayload p = new PublishPayload(this.commonTags, batch);
                    HttpResponse res = HttpClient.DEFAULT.newRequest("spectator-reg-atlas", this.uri).withMethod("POST").withConnectTimeout(this.connectTimeout).withReadTimeout(this.readTimeout).withContent("application/x-jackson-smile", this.smileMapper.writeValueAsBytes(p)).send();
                    Instant date = res.dateHeader("Date");
                    this.recordClockSkew(date == null ? 0L : date.toEpochMilli());
                }
            }
            catch (Exception e) {
                this.logger.warn("failed to send metrics", e);
            }
        }
    }

    private void handleSubscriptions() {
        ArrayList<Subscription> subs = new ArrayList<Subscription>(this.subscriptions.keySet());
        if (!subs.isEmpty()) {
            List<TagsValuePair> ms = this.getMeasurements().stream().map(this::newTagsValuePair).collect(Collectors.toList());
            Evaluator evaluator = new Evaluator().addGroupSubscriptions("local", subs);
            EvalPayload payload = evaluator.eval("local", this.clock().wallTime(), ms);
            try {
                String json = this.jsonMapper.writeValueAsString(payload);
                HttpClient.DEFAULT.newRequest("spectator-lwc-eval", this.evalUri).withMethod("POST").withConnectTimeout(this.connectTimeout).withReadTimeout(this.readTimeout).withJsonContent(json).send().decompress();
            }
            catch (Exception e) {
                this.logger.warn("failed to send metrics for subscriptions", e);
            }
        }
    }

    private void fetchSubscriptions() {
        try {
            HttpResponse res = HttpClient.DEFAULT.newRequest("spectator-lwc-subs", this.configUri).withMethod("GET").withConnectTimeout(this.connectTimeout).withReadTimeout(this.readTimeout).send().decompress();
            if (res.status() != 200) {
                this.logger.warn("failed to update subscriptions, received status {}", (Object)res.status());
            } else {
                Subscriptions subs = this.jsonMapper.readValue(res.entity(), Subscriptions.class);
                long now = this.clock.wallTime();
                subs.update(this.subscriptions, now, now + this.configTTL);
            }
        }
        catch (Exception e) {
            this.logger.warn("failed to send metrics", e);
        }
    }

    private void recordClockSkew(long responseTimestamp) {
        if (responseTimestamp == 0L) {
            this.logger.debug("no date timestamp on response, cannot record skew");
        } else {
            long delta = this.clock.wallTime() - responseTimestamp;
            if (delta >= 0L) {
                this.timer(CLOCK_SKEW_TIMER, "id", "fast").record(delta, TimeUnit.MILLISECONDS);
            } else {
                this.timer(CLOCK_SKEW_TIMER, "id", "slow").record(-delta, TimeUnit.MILLISECONDS);
            }
            this.logger.debug("clock skew between client and server: {}ms", (Object)delta);
        }
    }

    private Map<String, String> toMap(Id id) {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Tag t : id.tags()) {
            String k = this.charset.replaceNonMembers(t.key(), '_');
            String v = this.overrides.getOrDefault(k, this.charset).replaceNonMembers(t.value(), '_');
            tags.put(k, v);
        }
        String name = this.overrides.getOrDefault("name", this.charset).replaceNonMembers(id.name(), '_');
        tags.put("name", name);
        return tags;
    }

    private TagsValuePair newTagsValuePair(Measurement m) {
        Map<String, String> tags = this.toMap(m.id());
        tags.putAll(this.commonTags);
        return new TagsValuePair(tags, m.value());
    }

    List<Measurement> getMeasurements() {
        return this.stream().filter(m -> !m.hasExpired()).flatMap(m -> StreamSupport.stream(m.measure().spliterator(), false)).collect(Collectors.toList());
    }

    List<List<Measurement>> getBatches() {
        ArrayList<List<Measurement>> batches = new ArrayList<List<Measurement>>();
        List<Measurement> ms = this.getMeasurements();
        for (int i = 0; i < ms.size(); i += this.batchSize) {
            List<Measurement> batch = ms.subList(i, Math.min(ms.size(), i + this.batchSize));
            batches.add(batch);
        }
        return batches;
    }

    @Override
    protected Counter newCounter(Id id) {
        return new AtlasCounter(id, this.clock, this.meterTTL, this.stepMillis);
    }

    @Override
    protected DistributionSummary newDistributionSummary(Id id) {
        return new AtlasDistributionSummary(id, this.clock, this.meterTTL, this.stepMillis);
    }

    @Override
    protected Timer newTimer(Id id) {
        return new AtlasTimer(id, this.clock, this.meterTTL, this.stepMillis);
    }

    @Override
    protected Gauge newGauge(Id id) {
        return new AtlasGauge(id, this.clock(), this.meterTTL);
    }
}

