/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.agent;

import com.netflix.spectator.agent.JmxConfig;
import com.netflix.spectator.agent.JmxMeter;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.atlas.AtlasConfig;
import com.netflix.spectator.atlas.AtlasRegistry;
import com.netflix.spectator.gc.GcLogger;
import com.netflix.spectator.jvm.Jmx;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.lang.instrument.Instrumentation;

public final class Agent {
    private Agent() {
    }

    private static Config loadConfig(String userResources) {
        Config config = ConfigFactory.load((String)"agent");
        if (userResources != null && !"".equals(userResources)) {
            for (String userResource : userResources.split("[,\\s]+]")) {
                Config user = ConfigFactory.load((String)userResource);
                config = user.withFallback((ConfigMergeable)config);
            }
        }
        return config.getConfig("netflix.spectator.agent");
    }

    public static void premain(String arg, Instrumentation instrumentation) throws Exception {
        Config config = Agent.loadConfig(arg);
        AtlasConfig atlasConfig = k -> config.hasPath(k) ? config.getString(k) : null;
        AtlasRegistry registry = new AtlasRegistry(Clock.SYSTEM, atlasConfig);
        Spectator.globalRegistry().add((Registry)registry);
        GcLogger gcLogger = new GcLogger();
        if (config.getBoolean("collection.gc")) {
            gcLogger.start(null);
        }
        if (config.getBoolean("collection.jvm")) {
            Jmx.registerStandardMXBeans((Registry)registry);
        }
        if (config.getBoolean("collection.jmx")) {
            for (Config cfg : config.getConfigList("jmx.mappings")) {
                registry.register((Meter)new JmxMeter((Registry)registry, JmxConfig.from(cfg)));
            }
        }
        registry.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((AtlasRegistry)registry).stop(), "spectator-agent-shutdown"));
    }
}

