/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish.tomcat;

import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.publish.BaseMetricPoller;
import com.netflix.servo.tag.BasicTagList;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.tag.Tags;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TomcatPoller
extends BaseMetricPoller {
    private static final List<Metric> EMPTY_LIST = Collections.emptyList();
    private static final Logger LOGGER = LoggerFactory.getLogger(TomcatPoller.class);
    private static final String[] THREAD_POOL_ATTRS = new String[]{"maxThreads", "currentThreadCount", "currentThreadsBusy", "backlog"};
    private static final String[] GLOBAL_REQ_ATTRS = new String[]{"requestCount", "errorCount", "bytesSent", "processingTime", "maxTime"};
    private static final String[] EXECUTOR_ATTRS = new String[]{"maxThreads", "completedTaskCount", "queueSize", "poolSize", "activeCount"};

    private static String normalizeName(String name) {
        return "tomcat." + ("activeCount".equals(name) ? "currentThreadsBusy" : name);
    }

    private static Metric toMetric(long t, ObjectName name, Attribute attribute, Tag dsType) {
        Tag id = Tags.newTag((String)"id", (String)name.getKeyProperty("name"));
        Tag clazz = Tags.newTag((String)"class", (String)name.getKeyProperty("type"));
        BasicTagList list = BasicTagList.of((Tag[])new Tag[]{id, clazz, dsType});
        return new Metric(TomcatPoller.normalizeName(attribute.getName()), (TagList)list, t, attribute.getValue());
    }

    private static Metric toGauge(long t, ObjectName name, Attribute attribute) {
        return TomcatPoller.toMetric(t, name, attribute, (Tag)DataSourceType.GAUGE);
    }

    private static Metric toCounter(long t, ObjectName name, Attribute attribute) {
        return TomcatPoller.toMetric(t, name, attribute, (Tag)DataSourceType.COUNTER);
    }

    private static void addMetric(List<Metric> metrics, Metric metric) {
        if (metric.getNumberValue().doubleValue() >= 0.0) {
            MonitorConfig c = metric.getConfig();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding " + c.getName() + " " + c.getTags() + " " + metric.getNumberValue());
            }
            metrics.add(metric);
        } else {
            LOGGER.debug("Ignoring {}", (Object)metric);
        }
    }

    private static void fetchRequestProcessorMetrics(long now, MBeanServer mbs, List<Metric> metrics) throws JMException {
        ObjectName globalName = new ObjectName("Catalina:type=GlobalRequestProcessor,*");
        Set<ObjectName> names = mbs.queryNames(globalName, null);
        if (names == null) {
            return;
        }
        for (ObjectName name : names) {
            AttributeList list = mbs.getAttributes(name, GLOBAL_REQ_ATTRS);
            for (Attribute a : list.asList()) {
                TomcatPoller.addMetric(metrics, a.getName().equals("maxTime") ? TomcatPoller.toGauge(now, name, a) : TomcatPoller.toCounter(now, name, a));
            }
        }
    }

    private static void fetchThreadPoolMetrics(long now, MBeanServer mbs, List<Metric> metrics) throws JMException {
        ObjectName threadPoolName = new ObjectName("Catalina:type=ThreadPool,*");
        Set<ObjectName> names = mbs.queryNames(threadPoolName, null);
        if (names == null) {
            return;
        }
        for (ObjectName name : names) {
            AttributeList list = mbs.getAttributes(name, THREAD_POOL_ATTRS);
            boolean isUsed = true;
            for (Attribute a : list.asList()) {
                if (!a.getName().equals("maxThreads")) continue;
                Number v = (Number)a.getValue();
                isUsed = v.doubleValue() >= 0.0;
                break;
            }
            if (!isUsed) continue;
            for (Attribute a : list.asList()) {
                TomcatPoller.addMetric(metrics, TomcatPoller.toGauge(now, name, a));
            }
        }
    }

    private static void fetchExecutorMetrics(long now, MBeanServer mbs, List<Metric> metrics) throws JMException {
        ObjectName executorName = new ObjectName("Catalina:type=Executor,*");
        Set<ObjectName> names = mbs.queryNames(executorName, null);
        if (names == null) {
            return;
        }
        for (ObjectName name : names) {
            AttributeList list = mbs.getAttributes(name, EXECUTOR_ATTRS);
            for (Attribute a : list.asList()) {
                TomcatPoller.addMetric(metrics, a.getName().equals("completedTaskCount") ? TomcatPoller.toCounter(now, name, a) : TomcatPoller.toGauge(now, name, a));
            }
        }
    }

    List<Metric> pollImpl(long timestamp) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ArrayList<Metric> metrics = new ArrayList<Metric>();
            TomcatPoller.fetchThreadPoolMetrics(timestamp, mbs, metrics);
            TomcatPoller.fetchRequestProcessorMetrics(timestamp, mbs, metrics);
            TomcatPoller.fetchExecutorMetrics(timestamp, mbs, metrics);
            return metrics;
        }
        catch (JMException e) {
            this.logger.error("Could not get Tomcat JMX metrics", (Throwable)e);
            return EMPTY_LIST;
        }
    }

    public List<Metric> pollImpl(boolean reset) {
        return this.pollImpl(System.currentTimeMillis());
    }
}

