/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish.graphite;

import com.netflix.servo.Metric;
import com.netflix.servo.publish.BaseMetricObserver;
import com.netflix.servo.publish.graphite.BasicGraphiteNamingConvention;
import com.netflix.servo.publish.graphite.GraphiteNamingConvention;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.net.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteMetricObserver
extends BaseMetricObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphiteMetricObserver.class);
    private final GraphiteNamingConvention namingConvention;
    private final String serverPrefix;
    private final SocketFactory socketFactory = SocketFactory.getDefault();
    private final URI graphiteServerURI;
    private Socket socket = null;

    public GraphiteMetricObserver(String metricPrefix, String graphiteServerAddress) {
        this(metricPrefix, graphiteServerAddress, new BasicGraphiteNamingConvention());
    }

    public GraphiteMetricObserver(String metricPrefix, String graphiteServerAddress, GraphiteNamingConvention namingConvention) {
        super("GraphiteMetricObserver" + metricPrefix);
        this.namingConvention = namingConvention;
        this.serverPrefix = metricPrefix;
        this.graphiteServerURI = GraphiteMetricObserver.parseStringAsUri(graphiteServerAddress);
    }

    public void stop() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
                LOGGER.info("Disconnected from graphite server: {}", (Object)this.graphiteServerURI);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error Stopping", (Throwable)e);
        }
    }

    public void updateImpl(List<Metric> metrics) {
        try {
            if (this.connectionAvailable()) {
                this.write(this.socket, metrics);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Graphite connection failed on write", (Throwable)e);
            this.incrementFailedCount();
            this.stop();
        }
    }

    private boolean connectionAvailable() throws IOException {
        if (this.socket == null || !this.socket.isConnected()) {
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = this.socketFactory.createSocket(this.graphiteServerURI.getHost(), this.graphiteServerURI.getPort());
            LOGGER.info("Connected to graphite server: {}", (Object)this.graphiteServerURI);
        }
        return this.socket.isConnected();
    }

    private void write(Socket socket, Iterable<Metric> metrics) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
        int count = this.writeMetrics(metrics, writer);
        boolean checkError = writer.checkError();
        if (checkError) {
            throw new IOException("Writing to socket has failed");
        }
        this.checkNoReturnedData(socket);
        LOGGER.debug("Wrote {} metrics to graphite", (Object)count);
    }

    private int writeMetrics(Iterable<Metric> metrics, PrintWriter writer) {
        int count = 0;
        for (Metric metric : metrics) {
            String publishedName = this.namingConvention.getName(metric);
            StringBuilder sb = new StringBuilder();
            if (this.serverPrefix != null) {
                sb.append(this.serverPrefix).append(".");
            }
            sb.append(publishedName).append(" ");
            sb.append(metric.getValue().toString()).append(" ");
            sb.append(metric.getTimestamp() / 1000L);
            LOGGER.debug("{}", (Object)sb);
            writer.write(sb.append("\n").toString());
            ++count;
        }
        return count;
    }

    private void checkNoReturnedData(Socket socket) throws IOException {
        int toRead;
        byte[] buffer;
        int read;
        BufferedInputStream reader = new BufferedInputStream(socket.getInputStream());
        if (reader.available() > 0 && (read = reader.read(buffer = new byte[1000], 0, toRead = Math.min(reader.available(), 1000))) > 0) {
            LOGGER.warn("Data returned by graphite server when expecting no response! Probably aimed at wrong socket or server. Make sure you are publishing to the data port, not the dashboard port. First {} bytes of response: {}", (Object)read, (Object)new String(buffer, 0, read, "UTF-8"));
        }
    }

    private static URI parseStringAsUri(String ipString) {
        try {
            URI uri = new URI("socket://" + ipString);
            if (uri.getHost() == null || uri.getPort() == -1) {
                throw new URISyntaxException(ipString, "URI must have host and port parts");
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Graphite server address needs to be defined as {host}:{port}.");
        }
    }
}

