/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish.graphite;

import com.netflix.servo.Metric;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.publish.graphite.GraphiteNamingConvention;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;

public class BasicGraphiteNamingConvention
implements GraphiteNamingConvention {
    private static final String JMX_DOMAIN_KEY = "JmxDomain";

    @Override
    public String getName(Metric metric) {
        MonitorConfig config = metric.getConfig();
        TagList tags = config.getTags();
        Tag domainTag = tags.getTag(JMX_DOMAIN_KEY);
        if (domainTag != null) {
            return this.handleJmxMetric(config, tags);
        }
        return this.handleMetric(config, tags);
    }

    private String handleMetric(MonitorConfig config, TagList tags) {
        String type = this.cleanValue(tags.getTag("type"), false);
        String instanceName = this.cleanValue(tags.getTag("instance"), false);
        String name = this.cleanupIllegalCharacters(config.getName(), false);
        StringBuilder nameBuilder = new StringBuilder();
        if (type != null) {
            nameBuilder.append(type).append(".");
        }
        if (instanceName != null) {
            nameBuilder.append(instanceName).append(".");
        }
        if (name != null) {
            nameBuilder.append(name).append(".");
        }
        nameBuilder.deleteCharAt(nameBuilder.lastIndexOf("."));
        return nameBuilder.toString();
    }

    private String handleJmxMetric(MonitorConfig config, TagList tags) {
        String domain = this.cleanValue(tags.getTag(JMX_DOMAIN_KEY), true);
        String type = this.cleanValue(tags.getTag("Jmx.type"), false);
        String instanceName = this.cleanValue(tags.getTag("Jmx.instance"), false);
        String name = this.cleanValue(tags.getTag("Jmx.name"), false);
        String fieldName = this.cleanupIllegalCharacters(config.getName(), false);
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(domain).append(".");
        if (type != null) {
            nameBuilder.append(type).append(".");
        }
        if (instanceName != null) {
            nameBuilder.append(instanceName).append(".");
        }
        if (name != null) {
            nameBuilder.append(name).append(".");
        }
        if (fieldName != null) {
            nameBuilder.append(fieldName).append(".");
        }
        nameBuilder.deleteCharAt(nameBuilder.lastIndexOf("."));
        return nameBuilder.toString();
    }

    private String cleanValue(Tag tag, boolean allowPeriodsInName) {
        if (tag == null) {
            return null;
        }
        return this.cleanupIllegalCharacters(tag.getValue(), allowPeriodsInName);
    }

    private String cleanupIllegalCharacters(String s, boolean allowPeriodsInName) {
        if (!allowPeriodsInName) {
            s = s.replace(".", "_");
        }
        return s.replace(" ", "_");
    }
}

