/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.example;

import com.google.common.io.CountingInputStream;
import com.google.common.io.CountingOutputStream;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BaseHandler
implements HttpHandler {
    private final Timer latency = Monitors.newTimer((String)"latency");
    private final Counter bytesReceived = Monitors.newCounter((String)"bytesReceived");
    private final Counter bytesSent = Monitors.newCounter((String)"bytesSent");

    public void init() {
        Monitors.registerObject((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        CountingInputStream input = new CountingInputStream(exchange.getRequestBody());
        CountingOutputStream output = new CountingOutputStream(exchange.getResponseBody());
        exchange.setStreams((InputStream)input, (OutputStream)output);
        Stopwatch stopwatch = this.latency.start();
        try {
            this.handleImpl(exchange);
        }
        finally {
            stopwatch.stop();
            this.bytesReceived.increment(input.getCount());
            this.bytesSent.increment(output.getCount());
        }
    }

    protected abstract void handleImpl(HttpExchange var1) throws IOException;
}

