/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.example;

import com.netflix.servo.monitor.Pollers;
import java.io.File;

public final class Config {
    private Config() {
    }

    public static int getPort() {
        return Integer.parseInt(System.getProperty("servo.example.port", "12345"));
    }

    public static long getPollInterval() {
        return (Long)Pollers.getPollingIntervals().get(0) / 1000L;
    }

    public static boolean isFileObserverEnabled() {
        return Boolean.valueOf(System.getProperty("servo.example.isFileObserverEnabled", "true"));
    }

    public static File getFileObserverDirectory() {
        return new File(System.getProperty("servo.example.fileObserverDirectory", "/tmp"));
    }

    public static boolean isGraphiteObserverEnabled() {
        return Boolean.valueOf(System.getProperty("servo.example.isGraphiteObserverEnabled", "false"));
    }

    public static String getGraphiteObserverPrefix() {
        return System.getProperty("servo.example.graphiteObserverPrefix", "servo");
    }

    public static String getGraphiteObserverAddress() {
        return System.getProperty("servo.example.graphiteObserverAddress", "localhost:2003");
    }

    public static boolean isJvmPollerEnabled() {
        return Boolean.valueOf(System.getProperty("servo.example.isJvmPollerEnabled", "true"));
    }
}

