/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish.cloudwatch;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.netflix.servo.Metric;
import com.netflix.servo.aws.AwsServiceClients;
import com.netflix.servo.publish.BaseMetricObserver;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.util.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudWatchMetricObserver
extends BaseMetricObserver {
    private static final Logger LOG = LoggerFactory.getLogger(CloudWatchMetricObserver.class);
    private static final int MAX_EXPONENT = 360;
    private static final int MIN_EXPONENT = -360;
    static final double MAX_VALUE = Math.pow(2.0, 360.0);
    private int batchSize;
    private boolean truncateEnabled = false;
    private final AmazonCloudWatch cloudWatch;
    private final String cloudWatchNamespace;

    @Deprecated
    public CloudWatchMetricObserver(String name, String namespace, AWSCredentials credentials) {
        this(name, namespace, (AmazonCloudWatch)new AmazonCloudWatchClient(credentials));
    }

    @Deprecated
    public CloudWatchMetricObserver(String name, String namespace, AWSCredentials credentials, int batchSize) {
        this(name, namespace, credentials);
        this.batchSize = batchSize;
    }

    public CloudWatchMetricObserver(String name, String namespace, AWSCredentialsProvider provider) {
        this(name, namespace, AwsServiceClients.cloudWatch(provider));
    }

    public CloudWatchMetricObserver(String name, String namespace, AWSCredentialsProvider provider, int batchSize) {
        this(name, namespace, provider);
        this.batchSize = batchSize;
    }

    public CloudWatchMetricObserver(String name, String namespace, AmazonCloudWatch cloudWatch) {
        super(name);
        this.cloudWatch = cloudWatch;
        this.cloudWatchNamespace = namespace;
        this.batchSize = 20;
    }

    public CloudWatchMetricObserver(String name, String namespace, AmazonCloudWatch cloudWatch, int batchSize) {
        this(name, namespace, cloudWatch);
        this.batchSize = batchSize;
    }

    public void updateImpl(List<Metric> metrics) {
        Preconditions.checkNotNull(metrics, (String)"metrics");
        ArrayList<Metric> batch = new ArrayList<Metric>(this.batchSize);
        int batchCount = 1;
        while (metrics.size() > 0) {
            Metric m = metrics.remove(0);
            if (!m.hasNumberValue()) continue;
            batch.add(m);
            if (batchCount++ % this.batchSize != 0) continue;
            this.putMetricData(batch);
            batch.clear();
        }
        if (!batch.isEmpty()) {
            this.putMetricData(batch);
        }
    }

    private void putMetricData(List<Metric> batch) {
        try {
            this.cloudWatch.putMetricData(this.createPutRequest(batch));
        }
        catch (Exception e) {
            LOG.error("Error while submitting data for metrics : " + batch, (Throwable)e);
        }
    }

    PutMetricDataRequest createPutRequest(List<Metric> batch) {
        ArrayList<MetricDatum> datumList = new ArrayList<MetricDatum>(batch.size());
        for (Metric m : batch) {
            datumList.add(this.createMetricDatum(m));
        }
        return new PutMetricDataRequest().withNamespace(this.cloudWatchNamespace).withMetricData(datumList);
    }

    MetricDatum createMetricDatum(Metric metric) {
        MetricDatum metricDatum = new MetricDatum();
        return metricDatum.withMetricName(metric.getConfig().getName()).withDimensions(this.createDimensions(metric.getConfig().getTags())).withUnit("None").withTimestamp(new Date(metric.getTimestamp())).withValue(this.truncate(metric.getNumberValue()));
    }

    Double truncate(Number numberValue) {
        double doubleValue = numberValue.doubleValue();
        if (this.truncateEnabled) {
            int exponent = Math.getExponent(doubleValue);
            if (Double.isNaN(doubleValue)) {
                doubleValue = 0.0;
            } else if (exponent >= 360) {
                doubleValue = doubleValue < 0.0 ? -MAX_VALUE : MAX_VALUE;
            } else if (exponent <= -360) {
                doubleValue = 0.0;
            }
        }
        return doubleValue;
    }

    List<Dimension> createDimensions(TagList tags) {
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(tags.size());
        for (Tag tag : tags) {
            dimensionList.add(new Dimension().withName(tag.getKey()).withValue(tag.getValue()));
        }
        return dimensionList;
    }

    public CloudWatchMetricObserver withTruncateEnabled(boolean truncateEnabled) {
        this.truncateEnabled = truncateEnabled;
        return this;
    }
}

