/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.tag.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.autoscaling.model.AutoScalingInstanceDetails;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.google.common.io.Closeables;
import com.netflix.servo.aws.constants.Dimensions;
import com.netflix.servo.tag.Tag;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AwsInjectableTag implements Tag
{
    AUTOSCALE_GROUP(Dimensions.AUTOSCALING_GROUP.getAwsString(), AwsInjectableTag.getAutoScaleGroup()),
    INSTANCE_ID(Dimensions.INSTANCE_ID.getAwsString(), AwsInjectableTag.getInstanceId()),
    AVAILABILITY_ZONE(Dimensions.AVAILABILITY_ZONE.getAwsString(), AwsInjectableTag.getZone()),
    AMI_ID(Dimensions.AMI_IMAGE_ID.getAwsString(), AwsInjectableTag.getAmiId()),
    INSTANCE_TYPE(Dimensions.INSTANCE_TYPE.getAwsString(), AwsInjectableTag.getInstanceType()),
    LOCAL_HOSTNAME("local-hostname", AwsInjectableTag.getLocalHostname()),
    LOCAL_IPV4("local-ipv4", AwsInjectableTag.getLocalIpv4()),
    PUBLIC_HOSTNAME("public-hostname", AwsInjectableTag.getPublicHostname()),
    PUBLIC_IPV4("public-ipv4", AwsInjectableTag.getPublicIpv4());

    private static final String metaDataUrl = "http://169.254.169.254/latest/meta-data";
    private static final String undefined = "undefined";
    private static final Logger log;
    private final String key;
    private final String value;

    private AwsInjectableTag(String string2, String string3) {
        this.key = string2;
        this.value = string3;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String tagString() {
        return this.key + "=" + this.value;
    }

    static String getAutoScaleGroup() {
        try {
            File file = new File(System.getProperties().getProperty("com.netflix.servo.aws.credentialsFile"));
            AmazonAutoScalingClient amazonAutoScalingClient = new AmazonAutoScalingClient((AWSCredentials)new PropertiesCredentials(file));
            return ((AutoScalingInstanceDetails)amazonAutoScalingClient.describeAutoScalingInstances(new DescribeAutoScalingInstancesRequest().withInstanceIds(new String[]{AwsInjectableTag.getInstanceId()})).getAutoScalingInstances().get(0)).getAutoScalingGroupName();
        }
        catch (Exception exception) {
            log.error("Unable to get ASG name.", (Throwable)exception);
            return undefined;
        }
    }

    static String getInstanceId() {
        return AwsInjectableTag.getUrlValue("/instance-id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getUrlValue(String string) {
        BufferedReader bufferedReader = null;
        try {
            URL uRL = new URL(metaDataUrl + string);
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string2 = null;
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = System.getProperty("line.separator");
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append(string3);
            }
            String string4 = stringBuilder.toString();
            Closeables.closeQuietly((Closeable)bufferedReader);
            return string4;
        }
        catch (Exception exception) {
            log.warn("", (Throwable)exception);
            String string5 = undefined;
            return string5;
        }
        finally {
            Closeables.closeQuietly(bufferedReader);
        }
    }

    static String getZone() {
        return AwsInjectableTag.getUrlValue("/placement/availability-zone");
    }

    static String getAmiId() {
        return AwsInjectableTag.getUrlValue("/ami-id");
    }

    static String getInstanceType() {
        return AwsInjectableTag.getUrlValue("/instance-type");
    }

    static String getLocalHostname() {
        return AwsInjectableTag.getUrlValue("/local-hostname");
    }

    static String getLocalIpv4() {
        return AwsInjectableTag.getUrlValue("/local-ipv4");
    }

    static String getPublicHostname() {
        return AwsInjectableTag.getUrlValue("/public-hostname");
    }

    static String getPublicIpv4() {
        return AwsInjectableTag.getUrlValue("/public-ipv4");
    }

    static {
        log = LoggerFactory.getLogger(AwsInjectableTag.class);
    }
}

