/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClient;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.netflix.servo.aws.AwsPropertyKeys;

public final class AwsServiceClients {
    private AwsServiceClients() {
    }

    public static AmazonCloudWatch cloudWatch(AWSCredentialsProvider credentials) {
        AmazonCloudWatchClient client = new AmazonCloudWatchClient(credentials);
        client.setEndpoint(System.getProperty(AwsPropertyKeys.AWS_CLOUD_WATCH_END_POINT.getBundle(), "monitoring.amazonaws.com"));
        return client;
    }

    public static AmazonAutoScaling autoScaling(AWSCredentials credentials) {
        AmazonAutoScalingClient client = new AmazonAutoScalingClient(credentials);
        client.setEndpoint(System.getProperty(AwsPropertyKeys.AWS_AUTO_SCALING_END_POINT.getBundle(), "autoscaling.amazonaws.com"));
        return client;
    }
}

