/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.testutils;

import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.MyDataCenterInfo;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DiscoveryManager.class, DiscoveryClient.class})
@PowerMockIgnore(value={"javax.management.*", "com.sun.jersey.*", "com.sun.*", "org.apache.*", "weblogic.*", "com.netflix.config.*", "com.sun.jndi.dns.*", "javax.naming.*", "com.netflix.logging.*", "javax.ws.*"})
@Ignore
public abstract class MockedDiscoveryServerListTest {
    protected abstract List<Server> getMockServerList();

    protected abstract String getVipAddress();

    static List<InstanceInfo> getDummyInstanceInfo(String appName, List<Server> serverList) {
        ArrayList<InstanceInfo> list = new ArrayList<InstanceInfo>();
        for (Server server : serverList) {
            InstanceInfo info = InstanceInfo.Builder.newBuilder().setAppName(appName).setHostName(server.getHost()).setPort(server.getPort()).setDataCenterInfo((DataCenterInfo)new MyDataCenterInfo(DataCenterInfo.Name.MyOwn)).build();
            list.add(info);
        }
        return list;
    }

    @Before
    public void setupMock() {
        List<InstanceInfo> instances = MockedDiscoveryServerListTest.getDummyInstanceInfo("dummy", this.getMockServerList());
        PowerMock.mockStatic(DiscoveryManager.class);
        PowerMock.mockStatic(DiscoveryClient.class);
        DiscoveryClient mockedDiscoveryClient = (DiscoveryClient)PowerMock.createMock(DiscoveryClient.class);
        DiscoveryManager mockedDiscoveryManager = (DiscoveryManager)PowerMock.createMock(DiscoveryManager.class);
        EasyMock.expect((Object)mockedDiscoveryClient.getEurekaClientConfig()).andReturn((Object)new DefaultEurekaClientConfig()).anyTimes();
        EasyMock.expect((Object)DiscoveryManager.getInstance()).andReturn((Object)mockedDiscoveryManager).anyTimes();
        EasyMock.expect((Object)mockedDiscoveryManager.getDiscoveryClient()).andReturn((Object)mockedDiscoveryClient).anyTimes();
        EasyMock.expect((Object)mockedDiscoveryClient.getInstancesByVipAddress(this.getVipAddress(), false, null)).andReturn(instances).anyTimes();
        PowerMock.replay((Object[])new Object[]{DiscoveryManager.class});
        PowerMock.replay((Object[])new Object[]{DiscoveryClient.class});
        PowerMock.replay((Object[])new Object[]{mockedDiscoveryManager});
        PowerMock.replay((Object[])new Object[]{mockedDiscoveryClient});
    }
}

