/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.serialization;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeDef<T> {
    private TypeToken<?> delegate;

    protected TypeDef() {
        Type superclass = this.getClass().getGenericSuperclass();
        Preconditions.checkArgument((boolean)(superclass instanceof ParameterizedType), (String)"%s isn't parameterized", (Object[])new Object[]{superclass});
        Type runtimeType = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        this.delegate = TypeToken.of((Type)runtimeType);
    }

    public static <T> TypeDef<T> fromClass(Class<T> classType) {
        TypeDef spec = new TypeDef<T>(){};
        spec.delegate = TypeToken.of(classType);
        return spec;
    }

    public static TypeDef<?> fromType(Type type) {
        TypeDef<Object> spec = new TypeDef<Object>(){};
        spec.delegate = TypeToken.of((Type)type);
        return spec;
    }

    public Class<? super T> getRawType() {
        return this.delegate.getRawType();
    }

    public Type getType() {
        return this.delegate.getType();
    }
}

