/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.client.http;

import com.netflix.client.IPrimeConnection;
import com.netflix.client.config.IClientConfig;
import com.netflix.http4.NFHttpClient;
import com.netflix.http4.NFHttpClientFactory;
import com.netflix.loadbalancer.Server;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPrimeConnection
implements IPrimeConnection {
    private static final Logger logger = LoggerFactory.getLogger(HttpPrimeConnection.class);
    private NFHttpClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(Server server, String primeConnectionsURIPath) throws Exception {
        String url = "http://" + server.getHostPort() + primeConnectionsURIPath;
        HttpGet get = new HttpGet(url);
        HttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)get);
            String resp = EntityUtils.toString((HttpEntity)response.getEntity());
            if (logger.isDebugEnabled()) {
                logger.debug("Response code:" + response.getStatusLine().getStatusCode());
                logger.debug("Response:" + resp);
            }
        }
        finally {
            get.abort();
        }
        return true;
    }

    public void initWithNiwsConfig(IClientConfig niwsClientConfig) {
        this.client = NFHttpClientFactory.getNamedNFHttpClient(niwsClientConfig.getClientName() + "-PrimeConnsClient");
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.client.getParams(), (int)2000);
    }
}

