/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.client.http;

import com.netflix.client.ClientRequest;
import com.netflix.client.config.IClientConfig;
import java.net.URI;
import javax.ws.rs.core.MultivaluedMap;

public class HttpClientRequest
extends ClientRequest {
    private MultivaluedMap<String, String> headers;
    private MultivaluedMap<String, String> queryParams;
    private Object entity;
    private Verb verb = Verb.GET;

    private HttpClientRequest() {
    }

    public MultivaluedMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Verb getVerb() {
        return this.verb;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public Object getEntity() {
        return this.entity;
    }

    public boolean isRetriable() {
        if (this.verb == Verb.GET && this.isRetriable == null) {
            return true;
        }
        return super.isRetriable();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public HttpClientRequest replaceUri(URI newURI) {
        return new Builder().setUri(newURI).setEntity(this.getEntity()).setHeaders(this.getHeaders()).setOverrideConfig(this.getOverrideConfig()).setQueryParams(this.getQueryParams()).setRetriable(this.isRetriable()).setLoadBalancerKey(this.getLoadBalancerKey()).setVerb(this.getVerb()).build();
    }

    public static class Builder {
        private HttpClientRequest request = new HttpClientRequest();

        public Builder setUri(URI uri) {
            this.request.setUri(uri);
            return this;
        }

        public Builder setHeaders(MultivaluedMap<String, String> headers) {
            this.request.headers = headers;
            return this;
        }

        public Builder setOverrideConfig(IClientConfig config) {
            this.request.setOverrideConfig(config);
            return this;
        }

        public Builder setRetriable(boolean retriable) {
            this.request.setRetriable(retriable);
            return this;
        }

        public Builder setQueryParams(MultivaluedMap<String, String> queryParams) {
            this.request.queryParams = queryParams;
            return this;
        }

        public Builder setEntity(Object entity) {
            this.request.entity = entity;
            return this;
        }

        public Builder setVerb(Verb verb) {
            this.request.verb = verb;
            return this;
        }

        public Builder setLoadBalancerKey(Object loadBalancerKey) {
            this.request.setLoadBalancerKey(loadBalancerKey);
            return this;
        }

        public HttpClientRequest build() {
            return this.request;
        }
    }

    public static enum Verb {
        GET("GET"),
        PUT("PUT"),
        POST("POST"),
        DELETE("DELETE"),
        OPTIONS("OPTIONS"),
        HEAD("HEAD");

        private final String verb;

        private Verb(String verb) {
            this.verb = verb;
        }

        public String verb() {
            return this.verb;
        }
    }
}

