/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.rename;

import com.netflix.nebula.lint.rule.GradleLintRule;
import com.netflix.nebula.lint.rule.GradlePlugin;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.ToString;
import java.lang.ref.SoftReference;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;

@ToString
@EqualsAndHashCode
public class PluginRenamedRule
extends GradleLintRule {
    private String deprecatedPluginName;
    private String pluginName;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public PluginRenamedRule(String deprecatedPluginName, String pluginName) {
        String string;
        String string2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.deprecatedPluginName = string2 = deprecatedPluginName;
        this.pluginName = string = pluginName;
    }

    @Generated
    public PluginRenamedRule(String deprecatedPluginName) {
        CallSite[] callSiteArray = PluginRenamedRule.$getCallSiteArray();
        this(deprecatedPluginName, null);
    }

    @Generated
    public PluginRenamedRule() {
        CallSite[] callSiteArray = PluginRenamedRule.$getCallSiteArray();
        this(null, null);
    }

    @Override
    public String getDescription() {
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.deprecatedPluginName, this.pluginName}, new String[]{"the plugin name ", " has been deprecated in favor of ", ""}));
    }

    @Override
    public void visitApplyPlugin(MethodCallExpression call, String plugin) {
        if (ScriptBytecodeAdapter.compareEqual((Object)plugin, (Object)this.deprecatedPluginName)) {
            this.addBuildLintViolation(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.deprecatedPluginName, this.pluginName}, new String[]{"plugin ", " has been renamed to ", ""})), (ASTNode)call).replaceWith((ASTNode)call, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.pluginName}, new String[]{"apply plugin: '", "'"})));
        }
    }

    @Override
    public void visitGradlePlugin(MethodCallExpression call, String conf, GradlePlugin plugin) {
        if (ScriptBytecodeAdapter.compareEqual((Object)plugin.getId(), (Object)this.deprecatedPluginName)) {
            this.addBuildLintViolation(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.deprecatedPluginName, this.pluginName}, new String[]{"plugin ", " has been renamed to ", ""})), (ASTNode)call).replaceWith((ASTNode)call, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.pluginName}, new String[]{"id '", "'"})));
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PluginRenamedRule.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("com.netflix.nebula.lint.rule.rename.PluginRenamedRule(");
        Boolean bl = $toStringFirst;
        if (bl == null ? false : bl) {
            $toStringFirst = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getDeprecatedPluginName()));
        Boolean bl2 = $toStringFirst;
        if (bl2 == null ? false : bl2) {
            $toStringFirst = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getPluginName()));
        Boolean bl3 = $toStringFirst;
        if (bl3 == null ? false : bl3) {
            $toStringFirst = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getDescription()));
        _result.append(")");
        return _result.toString();
    }

    @Generated
    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getDeprecatedPluginName(), (Object)this)) {
            _result = HashCodeHelper.updateHash((int)_result, (Object)this.getDeprecatedPluginName());
        }
        if (ScriptBytecodeAdapter.compareNotIdentical((Object)this.getPluginName(), (Object)this)) {
            _result = HashCodeHelper.updateHash((int)_result, (Object)this.getPluginName());
        }
        return _result;
    }

    @Generated
    public boolean canEqual(Object other) {
        return other instanceof PluginRenamedRule;
    }

    @Generated
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof PluginRenamedRule)) {
            return false;
        }
        PluginRenamedRule otherTyped = (PluginRenamedRule)other;
        if (!otherTyped.canEqual(this)) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)this.getDeprecatedPluginName(), (Object)otherTyped.getDeprecatedPluginName())) {
            return false;
        }
        return !(!ScriptBytecodeAdapter.compareEqual((Object)this.getPluginName(), (Object)otherTyped.getPluginName()));
    }

    @Generated
    public String getDeprecatedPluginName() {
        return this.deprecatedPluginName;
    }

    @Generated
    public void setDeprecatedPluginName(String string) {
        this.deprecatedPluginName = string;
    }

    @Generated
    public String getPluginName() {
        return this.pluginName;
    }

    @Generated
    public void setPluginName(String string) {
        this.pluginName = string;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(PluginRenamedRule.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PluginRenamedRule.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

