/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.transport;

import com.netflix.nebula.lint.jgit.errors.PackProtocolException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.transport.BaseReceivePack;
import com.netflix.nebula.lint.jgit.transport.NonceGenerator;
import com.netflix.nebula.lint.jgit.transport.PacketLineIn;
import com.netflix.nebula.lint.jgit.transport.PushCertificate;
import com.netflix.nebula.lint.jgit.transport.PushCertificateIdent;
import com.netflix.nebula.lint.jgit.transport.ReceiveCommand;
import com.netflix.nebula.lint.jgit.transport.SignedPushConfig;
import com.netflix.nebula.lint.jgit.util.IO;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PushCertificateParser {
    static final String BEGIN_SIGNATURE = "-----BEGIN PGP SIGNATURE-----";
    static final String END_SIGNATURE = "-----END PGP SIGNATURE-----";
    static final String VERSION = "certificate version";
    static final String PUSHER = "pusher";
    static final String PUSHEE = "pushee";
    static final String NONCE = "nonce";
    static final String END_CERT = "push-cert-end";
    private static final String VERSION_0_1 = "0.1";
    private boolean received;
    private String version;
    private PushCertificateIdent pusher;
    private String pushee;
    private String sentNonce;
    private String receivedNonce;
    private PushCertificate.NonceStatus nonceStatus;
    private String signature;
    private final Repository db;
    private final int nonceSlopLimit;
    private final boolean enabled;
    private final NonceGenerator nonceGenerator;
    private final List<ReceiveCommand> commands = new ArrayList<ReceiveCommand>();

    public static PushCertificate fromReader(Reader r) throws PackProtocolException, IOException {
        return new PushCertificateParser().parse(r);
    }

    public static PushCertificate fromString(String str) throws PackProtocolException, IOException {
        return PushCertificateParser.fromReader(new java.io.StringReader(str));
    }

    public PushCertificateParser(Repository into, SignedPushConfig cfg) {
        if (cfg != null) {
            this.nonceSlopLimit = cfg.getCertNonceSlopLimit();
            this.nonceGenerator = cfg.getNonceGenerator();
        } else {
            this.nonceSlopLimit = 0;
            this.nonceGenerator = null;
        }
        this.db = into;
        this.enabled = this.nonceGenerator != null;
    }

    private PushCertificateParser() {
        this.db = null;
        this.nonceSlopLimit = 0;
        this.nonceGenerator = null;
        this.enabled = true;
    }

    public PushCertificate parse(Reader r) throws PackProtocolException, IOException {
        StreamReader reader = new StreamReader(r);
        this.receiveHeader(reader, true);
        try {
            String line;
            while (!(line = reader.read()).isEmpty()) {
                if (line.equals(BEGIN_SIGNATURE)) {
                    this.receiveSignature(reader);
                    break;
                }
                this.addCommand(line);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return this.build();
    }

    public PushCertificate build() throws IOException {
        if (!this.received || !this.enabled) {
            return null;
        }
        try {
            return new PushCertificate(this.version, this.pusher, this.pushee, this.receivedNonce, this.nonceStatus, Collections.unmodifiableList(this.commands), this.signature);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public boolean enabled() {
        return this.enabled;
    }

    public String getAdvertiseNonce() {
        String nonce = this.sentNonce();
        if (nonce == null) {
            return null;
        }
        return "push-cert=" + nonce;
    }

    private String sentNonce() {
        if (this.sentNonce == null && this.nonceGenerator != null) {
            this.sentNonce = this.nonceGenerator.createNonce(this.db, TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        }
        return this.sentNonce;
    }

    private static String parseHeader(StringReader reader, String header) throws IOException {
        return PushCertificateParser.parseHeader(reader.read(), header);
    }

    private static String parseHeader(String s, String header) throws IOException {
        if (s.isEmpty()) {
            throw new EOFException();
        }
        if (s.length() <= header.length() || !s.startsWith(header) || s.charAt(header.length()) != ' ') {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().pushCertificateInvalidField, header));
        }
        return s.substring(header.length() + 1);
    }

    public void receiveHeader(PacketLineIn pckIn, boolean stateless) throws IOException {
        this.receiveHeader(new PacketLineReader(pckIn), stateless);
    }

    private void receiveHeader(StringReader reader, boolean stateless) throws IOException {
        try {
            try {
                this.version = PushCertificateParser.parseHeader(reader, VERSION);
            }
            catch (EOFException e) {
                return;
            }
            this.received = true;
            if (!this.version.equals(VERSION_0_1)) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().pushCertificateInvalidFieldValue, VERSION, this.version));
            }
            String rawPusher = PushCertificateParser.parseHeader(reader, PUSHER);
            this.pusher = PushCertificateIdent.parse(rawPusher);
            if (this.pusher == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().pushCertificateInvalidFieldValue, PUSHER, rawPusher));
            }
            String next = reader.read();
            if (next.startsWith(PUSHEE)) {
                this.pushee = PushCertificateParser.parseHeader(next, PUSHEE);
                this.receivedNonce = PushCertificateParser.parseHeader(reader, NONCE);
            } else {
                this.receivedNonce = PushCertificateParser.parseHeader(next, NONCE);
            }
            PushCertificate.NonceStatus nonceStatus = this.nonceStatus = this.nonceGenerator != null ? this.nonceGenerator.verify(this.receivedNonce, this.sentNonce(), this.db, stateless, this.nonceSlopLimit) : PushCertificate.NonceStatus.UNSOLICITED;
            if (!reader.read().isEmpty()) {
                throw new PackProtocolException(JGitText.get().pushCertificateInvalidHeader);
            }
        }
        catch (EOFException eof) {
            throw new PackProtocolException(JGitText.get().pushCertificateInvalidHeader, eof);
        }
    }

    public void receiveSignature(PacketLineIn pckIn) throws IOException {
        PacketLineReader reader = new PacketLineReader(pckIn);
        this.receiveSignature(reader);
        if (!reader.read().equals(END_CERT)) {
            throw new PackProtocolException(JGitText.get().pushCertificateInvalidSignature);
        }
    }

    private void receiveSignature(StringReader reader) throws IOException {
        this.received = true;
        try {
            String line;
            StringBuilder sig = new StringBuilder(BEGIN_SIGNATURE).append('\n');
            while (!(line = reader.read()).equals(END_SIGNATURE)) {
                sig.append(line).append('\n');
            }
            this.signature = sig.append(END_SIGNATURE).append('\n').toString();
        }
        catch (EOFException eof) {
            throw new PackProtocolException(JGitText.get().pushCertificateInvalidSignature, eof);
        }
    }

    public void addCommand(ReceiveCommand cmd) {
        this.commands.add(cmd);
    }

    public void addCommand(String line) throws PackProtocolException {
        this.commands.add(BaseReceivePack.parseCommand(line));
    }

    private static class PacketLineReader
    implements StringReader {
        private final PacketLineIn pckIn;

        private PacketLineReader(PacketLineIn pckIn) {
            this.pckIn = pckIn;
        }

        @Override
        public String read() throws IOException {
            return this.pckIn.readString();
        }
    }

    private static class StreamReader
    implements StringReader {
        private final Reader reader;

        private StreamReader(Reader reader) {
            this.reader = reader;
        }

        @Override
        public String read() throws IOException {
            String line = IO.readLine(this.reader, 146);
            if (line.isEmpty()) {
                throw new EOFException();
            }
            if (line.charAt(line.length() - 1) == '\n') {
                line = line.substring(0, line.length() - 1);
            }
            return line;
        }
    }

    private static interface StringReader {
        public String read() throws EOFException, IOException;
    }
}

