/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.pack;

import com.netflix.nebula.lint.jgit.internal.storage.pack.DeltaCache;
import com.netflix.nebula.lint.jgit.internal.storage.pack.DeltaWindow;
import com.netflix.nebula.lint.jgit.internal.storage.pack.ObjectToPack;
import com.netflix.nebula.lint.jgit.lib.ObjectReader;
import com.netflix.nebula.lint.jgit.lib.ThreadSafeProgressMonitor;
import com.netflix.nebula.lint.jgit.storage.pack.PackConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

final class DeltaTask
implements Callable<Object> {
    static final long MAX_METER = 0x900000L;
    private final Block block;
    final LinkedList<Slice> slices;
    private ObjectReader or;
    private DeltaWindow dw;

    static int getAdjustedWeight(ObjectToPack o) {
        if (o.isEdge() || o.doNotAttemptDelta()) {
            return 0;
        }
        return o.getWeight();
    }

    DeltaTask(Block b) {
        this.block = b;
        this.slices = new LinkedList();
    }

    void add(Slice s) {
        if (!this.slices.isEmpty()) {
            Slice last = this.slices.getLast();
            if (last.endIndex == s.beginIndex) {
                this.slices.removeLast();
                this.slices.add(new Slice(last.beginIndex, s.endIndex));
                return;
            }
        }
        this.slices.add(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Object call() throws Exception {
        this.or = this.block.templateReader.newReader();
        try {
            while (true) {
                var2_2 = this;
                synchronized (var2_2) {
                    block9: {
                        if (!this.slices.isEmpty()) break block9;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 6] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                        if (true) ** GOTO lbl19
                    }
                    w = this.initWindow(this.slices.removeFirst());
                }
                this.runWindow(w);
            }
            do {
                this.runWindow(w);
lbl19:
                // 2 sources

            } while ((w = this.block.stealWork(this)) != null);
        }
        finally {
            this.block.pm.endWorker();
            this.or.close();
            this.or = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeltaWindow initWindow(Slice s) {
        DeltaWindow w = new DeltaWindow(this.block.config, this.block.dc, this.or, this.block.pm, this.block.bytesPerUnit, this.block.list, s.beginIndex, s.endIndex);
        DeltaTask deltaTask = this;
        synchronized (deltaTask) {
            this.dw = w;
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWindow(DeltaWindow w) throws IOException {
        try {
            w.search();
        }
        catch (Throwable throwable) {
            DeltaTask deltaTask = this;
            synchronized (deltaTask) {
                this.dw = null;
            }
            throw throwable;
        }
        DeltaTask deltaTask = this;
        synchronized (deltaTask) {
            this.dw = null;
        }
    }

    synchronized Slice remaining() {
        if (!this.slices.isEmpty()) {
            return this.slices.getLast();
        }
        DeltaWindow d = this.dw;
        return d != null ? d.remaining() : null;
    }

    synchronized boolean tryStealWork(Slice s) {
        if (!this.slices.isEmpty() && this.slices.getLast().beginIndex == s.beginIndex) {
            this.slices.removeLast();
            return true;
        }
        DeltaWindow d = this.dw;
        return d != null ? d.tryStealWork(s) : false;
    }

    static final class Block {
        private static final int MIN_TOP_PATH = 0x3200000;
        final List<DeltaTask> tasks;
        final int threads;
        final PackConfig config;
        final ObjectReader templateReader;
        final DeltaCache dc;
        final ThreadSafeProgressMonitor pm;
        final ObjectToPack[] list;
        final int beginIndex;
        final int endIndex;
        private long totalWeight;
        long bytesPerUnit;

        Block(int threads, PackConfig config, ObjectReader reader, DeltaCache dc, ThreadSafeProgressMonitor pm, ObjectToPack[] list, int begin, int end) {
            this.tasks = new ArrayList<DeltaTask>(threads);
            this.threads = threads;
            this.config = config;
            this.templateReader = reader;
            this.dc = dc;
            this.pm = pm;
            this.list = list;
            this.beginIndex = begin;
            this.endIndex = end;
        }

        int cost() {
            int d = (int)(this.totalWeight / this.bytesPerUnit);
            if (this.totalWeight % this.bytesPerUnit != 0L) {
                ++d;
            }
            return d;
        }

        synchronized DeltaWindow stealWork(DeltaTask forThread) {
            Slice maxSlice;
            DeltaTask maxTask;
            do {
                maxTask = null;
                maxSlice = null;
                int maxWork = 0;
                for (DeltaTask task : this.tasks) {
                    Slice s = task.remaining();
                    if (s == null || maxWork >= s.size()) continue;
                    maxTask = task;
                    maxSlice = s;
                    maxWork = s.size();
                }
                if (maxTask != null) continue;
                return null;
            } while (!maxTask.tryStealWork(maxSlice));
            return forThread.initWindow(maxSlice);
        }

        void partitionTasks() {
            DeltaTask task;
            ArrayList<WeightedPath> topPaths = this.computeTopPaths();
            Iterator<WeightedPath> topPathItr = topPaths.iterator();
            int nextTop = 0;
            long weightPerThread = Math.max(this.totalWeight / (long)this.threads, 1L);
            int i = this.beginIndex;
            while (i < this.endIndex) {
                task = new DeltaTask(this);
                long w = 0L;
                if (topPathItr.hasNext()) {
                    WeightedPath p = topPathItr.next();
                    w += p.weight;
                    task.add(p.slice);
                }
                int s = i;
                while (w < weightPerThread && i < this.endIndex) {
                    if (nextTop < topPaths.size() && i == topPaths.get((int)nextTop).slice.beginIndex) {
                        if (s < i) {
                            task.add(new Slice(s, i));
                        }
                        s = i = topPaths.get((int)nextTop++).slice.endIndex;
                        continue;
                    }
                    w += (long)DeltaTask.getAdjustedWeight(this.list[i++]);
                }
                if (s < i) {
                    int h = this.list[i - 1].getPathHash();
                    while (i < this.endIndex) {
                        if (h != this.list[i].getPathHash()) break;
                        ++i;
                    }
                    task.add(new Slice(s, i));
                }
                if (task.slices.isEmpty()) continue;
                this.tasks.add(task);
            }
            while (topPathItr.hasNext()) {
                WeightedPath p = topPathItr.next();
                task = new DeltaTask(this);
                task.add(p.slice);
                this.tasks.add(task);
            }
            topPaths = null;
        }

        private ArrayList<WeightedPath> computeTopPaths() {
            long cw;
            ArrayList<WeightedPath> topPaths = new ArrayList<WeightedPath>(this.threads);
            int cp = this.beginIndex;
            int ch = this.list[cp].getPathHash();
            this.totalWeight = cw = (long)DeltaTask.getAdjustedWeight(this.list[cp]);
            int i = cp + 1;
            while (i < this.endIndex) {
                ObjectToPack o = this.list[i];
                if (ch != o.getPathHash()) {
                    if (0x3200000L < cw) {
                        if (topPaths.size() < this.threads) {
                            Slice s = new Slice(cp, i);
                            topPaths.add(new WeightedPath(cw, s));
                            if (topPaths.size() == this.threads) {
                                Collections.sort(topPaths);
                            }
                        } else if (topPaths.get((int)0).weight < cw) {
                            Slice s = new Slice(cp, i);
                            WeightedPath p = new WeightedPath(cw, s);
                            topPaths.set(0, p);
                            if (p.compareTo(topPaths.get(1)) > 0) {
                                Collections.sort(topPaths);
                            }
                        }
                    }
                    cp = i;
                    ch = o.getPathHash();
                    cw = 0L;
                }
                int weight = DeltaTask.getAdjustedWeight(o);
                cw += (long)weight;
                this.totalWeight += (long)weight;
                ++i;
            }
            Collections.sort(topPaths, new Comparator<WeightedPath>(){

                @Override
                public int compare(WeightedPath a, WeightedPath b) {
                    return a.slice.beginIndex - b.slice.beginIndex;
                }
            });
            this.bytesPerUnit = 1L;
            while (0x900000L <= this.totalWeight / this.bytesPerUnit) {
                this.bytesPerUnit <<= 10;
            }
            return topPaths;
        }
    }

    static final class Slice {
        final int beginIndex;
        final int endIndex;

        Slice(int b, int e) {
            this.beginIndex = b;
            this.endIndex = e;
        }

        final int size() {
            return this.endIndex - this.beginIndex;
        }
    }

    static final class WeightedPath
    implements Comparable<WeightedPath> {
        final long weight;
        final Slice slice;

        WeightedPath(long weight, Slice s) {
            this.weight = weight;
            this.slice = s;
        }

        @Override
        public int compareTo(WeightedPath o) {
            int cmp = Long.signum(this.weight - o.weight);
            if (cmp != 0) {
                return cmp;
            }
            return this.slice.beginIndex - o.slice.beginIndex;
        }
    }
}

