/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.file;

import com.netflix.nebula.lint.jgit.internal.storage.file.ReflogEntryImpl;
import com.netflix.nebula.lint.jgit.lib.ReflogEntry;
import com.netflix.nebula.lint.jgit.lib.ReflogReader;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.util.IO;
import com.netflix.nebula.lint.jgit.util.RawParseUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ReflogReaderImpl
implements ReflogReader {
    private File logName;

    ReflogReaderImpl(Repository db, String refname) {
        this.logName = new File(db.getDirectory(), "logs/" + refname);
    }

    @Override
    public ReflogEntry getLastEntry() throws IOException {
        return this.getReverseEntry(0);
    }

    @Override
    public List<ReflogEntry> getReverseEntries() throws IOException {
        return this.getReverseEntries(Integer.MAX_VALUE);
    }

    @Override
    public ReflogEntry getReverseEntry(int number) throws IOException {
        byte[] log;
        if (number < 0) {
            throw new IllegalArgumentException();
        }
        try {
            log = IO.readFully(this.logName);
        }
        catch (FileNotFoundException e) {
            if (this.logName.exists()) {
                throw e;
            }
            return null;
        }
        int rs = RawParseUtils.prevLF(log, log.length);
        int current = 0;
        while (rs >= 0) {
            rs = RawParseUtils.prevLF(log, rs);
            if (number == current) {
                return new ReflogEntryImpl(log, rs < 0 ? 0 : rs + 2);
            }
            ++current;
        }
        return null;
    }

    @Override
    public List<ReflogEntry> getReverseEntries(int max) throws IOException {
        byte[] log;
        try {
            log = IO.readFully(this.logName);
        }
        catch (FileNotFoundException e) {
            if (this.logName.exists()) {
                throw e;
            }
            return Collections.emptyList();
        }
        int rs = RawParseUtils.prevLF(log, log.length);
        ArrayList<ReflogEntry> ret = new ArrayList<ReflogEntry>();
        while (rs >= 0 && max-- > 0) {
            ReflogEntryImpl entry = new ReflogEntryImpl(log, (rs = RawParseUtils.prevLF(log, rs)) < 0 ? 0 : rs + 2);
            ret.add(entry);
        }
        return ret;
    }
}

