/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.dfs;

import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.BlockBasedFile;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsObjDatabase;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsObjectRepresentation;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsOutputStream;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsPackDescription;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsPackFile;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsReader;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsReftable;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsRepository;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.ReftableStack;
import com.netflix.nebula.lint.jgit.internal.storage.file.PackIndex;
import com.netflix.nebula.lint.jgit.internal.storage.file.PackReverseIndex;
import com.netflix.nebula.lint.jgit.internal.storage.pack.PackExt;
import com.netflix.nebula.lint.jgit.internal.storage.pack.PackWriter;
import com.netflix.nebula.lint.jgit.internal.storage.reftable.ReftableCompactor;
import com.netflix.nebula.lint.jgit.internal.storage.reftable.ReftableConfig;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.NullProgressMonitor;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectIdSet;
import com.netflix.nebula.lint.jgit.lib.ObjectReader;
import com.netflix.nebula.lint.jgit.lib.ProgressMonitor;
import com.netflix.nebula.lint.jgit.revwalk.RevFlag;
import com.netflix.nebula.lint.jgit.revwalk.RevObject;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.storage.pack.PackConfig;
import com.netflix.nebula.lint.jgit.storage.pack.PackStatistics;
import com.netflix.nebula.lint.jgit.util.BlockList;
import com.netflix.nebula.lint.jgit.util.io.CountingOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DfsPackCompactor {
    private final DfsRepository repo;
    private final List<DfsPackFile> srcPacks;
    private final List<DfsReftable> srcReftables;
    private final List<ObjectIdSet> exclude;
    private PackStatistics newStats;
    private DfsPackDescription outDesc;
    private int autoAddSize;
    private ReftableConfig reftableConfig;
    private RevWalk rw;
    private RevFlag added;
    private RevFlag isBase;

    public DfsPackCompactor(DfsRepository repository) {
        this.repo = repository;
        this.autoAddSize = 0x500000;
        this.srcPacks = new ArrayList<DfsPackFile>();
        this.srcReftables = new ArrayList<DfsReftable>();
        this.exclude = new ArrayList<ObjectIdSet>(4);
    }

    public DfsPackCompactor setReftableConfig(ReftableConfig cfg) {
        this.reftableConfig = cfg;
        return this;
    }

    public DfsPackCompactor add(DfsPackFile pack) {
        this.srcPacks.add(pack);
        return this;
    }

    public DfsPackCompactor add(DfsReftable table) {
        this.srcReftables.add(table);
        return this;
    }

    public DfsPackCompactor autoAdd() throws IOException {
        DfsPackDescription d;
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        BlockBasedFile[] blockBasedFileArray = objdb.getPacks();
        int n = blockBasedFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            DfsPackFile pack = blockBasedFileArray[n2];
            d = pack.getPackDescription();
            if (d.getFileSize(PackExt.PACK) < (long)this.autoAddSize) {
                this.add(pack);
            } else {
                this.exclude(pack);
            }
            ++n2;
        }
        if (this.reftableConfig != null) {
            blockBasedFileArray = objdb.getReftables();
            n = blockBasedFileArray.length;
            n2 = 0;
            while (n2 < n) {
                BlockBasedFile table = blockBasedFileArray[n2];
                d = ((DfsReftable)table).getPackDescription();
                if (d.getPackSource() != DfsObjDatabase.PackSource.GC && d.getFileSize(PackExt.REFTABLE) < (long)this.autoAddSize) {
                    this.add((DfsReftable)table);
                }
                ++n2;
            }
        }
        return this;
    }

    public DfsPackCompactor exclude(ObjectIdSet set) {
        this.exclude.add(set);
        return this;
    }

    public DfsPackCompactor exclude(DfsPackFile pack) throws IOException {
        PackIndex idx;
        Throwable throwable = null;
        Object var4_4 = null;
        try (DfsReader ctx = (DfsReader)this.repo.newObjectReader();){
            idx = pack.getPackIndex(ctx);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.exclude(idx);
    }

    public void compact(ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (DfsReader ctx = objdb.newReader();){
                if (this.reftableConfig != null && !this.srcReftables.isEmpty()) {
                    this.compactReftables(ctx);
                }
                this.compactPacks(ctx, pm);
                List<DfsPackDescription> commit = this.getNewPacks();
                Collection<DfsPackDescription> remove = this.toPrune();
                if (!commit.isEmpty() || !remove.isEmpty()) {
                    objdb.commitPack(commit, remove);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.rw = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void compactPacks(DfsReader ctx, ProgressMonitor pm) throws IOException, IncorrectObjectTypeException {
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        PackConfig pc = new PackConfig(this.repo);
        pc.setIndexVersion(2);
        pc.setDeltaCompress(false);
        pc.setReuseDeltas(true);
        pc.setReuseObjects(true);
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            PackWriter pw = new PackWriter(pc, (ObjectReader)ctx);
            try {
                pw.setDeltaBaseAsOffset(true);
                pw.setReuseDeltaCommits(false);
                this.addObjectsToPack(pw, ctx, pm);
                if (pw.getObjectCount() == 0L) {
                    return;
                }
                boolean rollback = true;
                this.initOutDesc(objdb);
                try {
                    DfsPackCompactor.writePack(objdb, this.outDesc, pw, pm);
                    DfsPackCompactor.writeIndex(objdb, this.outDesc, pw);
                    PackStatistics stats = pw.getStatistics();
                    this.outDesc.setPackStats(stats);
                    this.newStats = stats;
                    rollback = false;
                    return;
                }
                finally {
                    if (rollback) {
                        objdb.rollbackPack(Collections.singletonList(this.outDesc));
                    }
                }
            }
            finally {
                if (pw == null) return;
                pw.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private long estimatePackSize() {
        long size = 32L;
        for (DfsPackFile pack : this.srcPacks) {
            size += pack.getPackDescription().getFileSize(PackExt.PACK) - 32L;
        }
        return size;
    }

    private void compactReftables(DfsReader ctx) throws IOException {
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        Collections.sort(this.srcReftables, objdb.reftableComparator());
        Throwable throwable = null;
        Object var4_5 = null;
        try (ReftableStack stack = ReftableStack.open(ctx, this.srcReftables);){
            this.initOutDesc(objdb);
            ReftableCompactor compact = new ReftableCompactor();
            compact.addAll(stack.readers());
            compact.setIncludeDeletes(true);
            this.writeReftable(objdb, this.outDesc, compact);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void initOutDesc(DfsObjDatabase objdb) throws IOException {
        if (this.outDesc == null) {
            this.outDesc = objdb.newPack(DfsObjDatabase.PackSource.COMPACT, this.estimatePackSize());
        }
    }

    public Collection<DfsPackDescription> getSourcePacks() {
        HashSet<DfsPackDescription> src = new HashSet<DfsPackDescription>();
        for (DfsPackFile pack : this.srcPacks) {
            src.add(pack.getPackDescription());
        }
        for (DfsReftable table : this.srcReftables) {
            src.add(table.getPackDescription());
        }
        return src;
    }

    public List<DfsPackDescription> getNewPacks() {
        return this.outDesc != null ? Collections.singletonList(this.outDesc) : Collections.emptyList();
    }

    public List<PackStatistics> getNewPackStatistics() {
        return this.outDesc != null ? Collections.singletonList(this.newStats) : Collections.emptyList();
    }

    private Collection<DfsPackDescription> toPrune() {
        DfsPackDescription d;
        HashSet<DfsPackDescription> packs = new HashSet<DfsPackDescription>();
        for (DfsPackFile pack : this.srcPacks) {
            packs.add(pack.getPackDescription());
        }
        HashSet<DfsPackDescription> reftables = new HashSet<DfsPackDescription>();
        for (DfsReftable table : this.srcReftables) {
            reftables.add(table.getPackDescription());
        }
        Iterator i = packs.iterator();
        while (i.hasNext()) {
            d = (DfsPackDescription)i.next();
            if (!d.hasFileExt(PackExt.REFTABLE) || reftables.contains(d)) continue;
            i.remove();
        }
        i = reftables.iterator();
        while (i.hasNext()) {
            d = (DfsPackDescription)i.next();
            if (!d.hasFileExt(PackExt.PACK) || packs.contains(d)) continue;
            i.remove();
        }
        HashSet<DfsPackDescription> toPrune = new HashSet<DfsPackDescription>();
        toPrune.addAll(packs);
        toPrune.addAll(reftables);
        return toPrune;
    }

    private void addObjectsToPack(PackWriter pw, DfsReader ctx, ProgressMonitor pm) throws IOException, IncorrectObjectTypeException {
        Collections.sort(this.srcPacks, new Comparator<DfsPackFile>(){

            @Override
            public int compare(DfsPackFile a, DfsPackFile b) {
                return a.getPackDescription().compareTo(b.getPackDescription());
            }
        });
        this.rw = new RevWalk(ctx);
        this.added = this.rw.newFlag("ADDED");
        this.isBase = this.rw.newFlag("IS_BASE");
        BlockList baseObjects = new BlockList();
        pm.beginTask(JGitText.get().countingObjects, 0);
        for (DfsPackFile src : this.srcPacks) {
            List<ObjectIdWithOffset> want = this.toInclude(src, ctx);
            if (want.isEmpty()) continue;
            PackReverseIndex rev = src.getReverseIdx(ctx);
            DfsObjectRepresentation rep = new DfsObjectRepresentation(src);
            for (ObjectIdWithOffset id : want) {
                RevObject base;
                int type;
                RevObject obj = this.rw.lookupAny(id, type = src.getObjectType(ctx, id.offset));
                if (obj.has(this.added)) continue;
                pm.update(1);
                pw.addObject(obj);
                obj.add(this.added);
                src.representation(rep, id.offset, ctx, rev);
                if (rep.getFormat() != 0 || (base = this.rw.lookupAny(rep.getDeltaBase(), type)).has(this.added) || base.has(this.isBase)) continue;
                baseObjects.add(base);
                base.add(this.isBase);
            }
        }
        for (RevObject obj : baseObjects) {
            if (obj.has(this.added)) continue;
            pm.update(1);
            pw.addObject(obj);
            obj.add(this.added);
        }
        pm.endTask();
    }

    private List<ObjectIdWithOffset> toInclude(DfsPackFile src, DfsReader ctx) throws IOException {
        PackIndex srcIdx = src.getPackIndex(ctx);
        BlockList<ObjectIdWithOffset> want = new BlockList<ObjectIdWithOffset>((int)srcIdx.getObjectCount());
        block0: for (PackIndex.MutableEntry ent : srcIdx) {
            ObjectId id = ent.toObjectId();
            RevObject obj = this.rw.lookupOrNull(id);
            if (obj != null && (obj.has(this.added) || obj.has(this.isBase))) continue;
            for (ObjectIdSet e : this.exclude) {
                if (e.contains(id)) continue block0;
            }
            want.add(new ObjectIdWithOffset(id, ent.getOffset()));
        }
        Collections.sort(want, new Comparator<ObjectIdWithOffset>(){

            @Override
            public int compare(ObjectIdWithOffset a, ObjectIdWithOffset b) {
                return Long.signum(a.offset - b.offset);
            }
        });
        return want;
    }

    private static void writePack(DfsObjDatabase objdb, DfsPackDescription pack, PackWriter pw, ProgressMonitor pm) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (DfsOutputStream out = objdb.writeFile(pack, PackExt.PACK);){
            pw.writePack(pm, pm, out);
            pack.addFileExt(PackExt.PACK);
            pack.setBlockSize(PackExt.PACK, out.blockSize());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeIndex(DfsObjDatabase objdb, DfsPackDescription pack, PackWriter pw) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DfsOutputStream out = objdb.writeFile(pack, PackExt.INDEX);){
            CountingOutputStream cnt = new CountingOutputStream(out);
            pw.writeIndex(cnt);
            pack.addFileExt(PackExt.INDEX);
            pack.setFileSize(PackExt.INDEX, cnt.getCount());
            pack.setBlockSize(PackExt.INDEX, out.blockSize());
            pack.setIndexVersion(pw.getIndexVersion());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void writeReftable(DfsObjDatabase objdb, DfsPackDescription pack, ReftableCompactor compact) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (DfsOutputStream out = objdb.writeFile(pack, PackExt.REFTABLE);){
            compact.setConfig(DfsPackCompactor.configureReftable(this.reftableConfig, out));
            compact.compact(out);
            pack.addFileExt(PackExt.REFTABLE);
            pack.setReftableStats(compact.getStats());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static ReftableConfig configureReftable(ReftableConfig cfg, DfsOutputStream out) {
        int bs = out.blockSize();
        if (bs > 0) {
            cfg = new ReftableConfig(cfg);
            cfg.setRefBlockSize(bs);
            cfg.setAlignBlocks(true);
        }
        return cfg;
    }

    private static class ObjectIdWithOffset
    extends ObjectId {
        final long offset;

        ObjectIdWithOffset(AnyObjectId id, long ofs) {
            super(id);
            this.offset = ofs;
        }
    }
}

