/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.ignore.internal;

import com.netflix.nebula.lint.jgit.ignore.internal.NameMatcher;

public class LeadingAsteriskMatcher
extends NameMatcher {
    LeadingAsteriskMatcher(String pattern, Character pathSeparator, boolean dirOnly) {
        super(pattern, pathSeparator, dirOnly, true);
        if (this.subPattern.charAt(0) != '*') {
            throw new IllegalArgumentException("Pattern must have leading asterisk: " + pattern);
        }
    }

    @Override
    public boolean matches(String segment, int startIncl, int endExcl) {
        String s = this.subPattern;
        int subLength = s.length() - 1;
        if (subLength == 0) {
            return true;
        }
        if (subLength > endExcl - startIncl) {
            return false;
        }
        int i = subLength;
        int j = endExcl - 1;
        while (i > 0) {
            char c2;
            char c1 = s.charAt(i);
            if (c1 != (c2 = segment.charAt(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }
}

