/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.hooks;

import com.netflix.nebula.lint.jgit.api.errors.AbortedByHookException;
import com.netflix.nebula.lint.jgit.lib.Constants;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.util.FS;
import com.netflix.nebula.lint.jgit.util.ProcessResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.Callable;

abstract class GitHook<T>
implements Callable<T> {
    private final Repository repo;
    protected final PrintStream outputStream;

    protected GitHook(Repository repo, PrintStream outputStream) {
        this.repo = repo;
        this.outputStream = outputStream;
    }

    @Override
    public abstract T call() throws IOException, AbortedByHookException;

    public abstract String getHookName();

    protected Repository getRepository() {
        return this.repo;
    }

    protected String[] getParameters() {
        return new String[0];
    }

    protected String getStdinArgs() {
        return null;
    }

    protected PrintStream getOutputStream() {
        return this.outputStream == null ? System.out : this.outputStream;
    }

    protected void doRun() throws AbortedByHookException {
        ByteArrayOutputStream errorByteArray = new ByteArrayOutputStream();
        PrintStream hookErrRedirect = null;
        try {
            hookErrRedirect = new PrintStream((OutputStream)errorByteArray, false, Constants.CHARSET.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ProcessResult result = FS.DETECTED.runHookIfPresent(this.getRepository(), this.getHookName(), this.getParameters(), this.getOutputStream(), hookErrRedirect, this.getStdinArgs());
        if (result.isExecutedWithError()) {
            throw new AbortedByHookException(new String(errorByteArray.toByteArray(), Constants.CHARSET), this.getHookName(), result.getExitCode());
        }
    }

    public boolean isNativeHookPresent() {
        return FS.DETECTED.findHook(this.getRepository(), this.getHookName()) != null;
    }
}

