/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.diff;

public class Edit {
    int beginA;
    int endA;
    int beginB;
    int endB;

    public Edit(int as, int bs) {
        this(as, as, bs, bs);
    }

    public Edit(int as, int ae, int bs, int be) {
        this.beginA = as;
        this.endA = ae;
        this.beginB = bs;
        this.endB = be;
    }

    public final Type getType() {
        if (this.beginA < this.endA) {
            if (this.beginB < this.endB) {
                return Type.REPLACE;
            }
            return Type.DELETE;
        }
        if (this.beginB < this.endB) {
            return Type.INSERT;
        }
        return Type.EMPTY;
    }

    public final boolean isEmpty() {
        return this.beginA == this.endA && this.beginB == this.endB;
    }

    public final int getBeginA() {
        return this.beginA;
    }

    public final int getEndA() {
        return this.endA;
    }

    public final int getBeginB() {
        return this.beginB;
    }

    public final int getEndB() {
        return this.endB;
    }

    public final int getLengthA() {
        return this.endA - this.beginA;
    }

    public final int getLengthB() {
        return this.endB - this.beginB;
    }

    public final void shift(int amount) {
        this.beginA += amount;
        this.endA += amount;
        this.beginB += amount;
        this.endB += amount;
    }

    public final Edit before(Edit cut) {
        return new Edit(this.beginA, cut.beginA, this.beginB, cut.beginB);
    }

    public final Edit after(Edit cut) {
        return new Edit(cut.endA, this.endA, cut.endB, this.endB);
    }

    public void extendA() {
        ++this.endA;
    }

    public void extendB() {
        ++this.endB;
    }

    public void swap() {
        int sBegin = this.beginA;
        int sEnd = this.endA;
        this.beginA = this.beginB;
        this.endA = this.endB;
        this.beginB = sBegin;
        this.endB = sEnd;
    }

    public int hashCode() {
        return this.beginA ^ this.endA;
    }

    public boolean equals(Object o) {
        if (o instanceof Edit) {
            Edit e = (Edit)o;
            return this.beginA == e.beginA && this.endA == e.endA && this.beginB == e.beginB && this.endB == e.endB;
        }
        return false;
    }

    public String toString() {
        Type t = this.getType();
        return (Object)((Object)t) + "(" + this.beginA + "-" + this.endA + "," + this.beginB + "-" + this.endB + ")";
    }

    public static enum Type {
        INSERT,
        DELETE,
        REPLACE,
        EMPTY;

    }
}

