/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.diff;

import com.netflix.nebula.lint.jgit.diff.DiffEntry;
import com.netflix.nebula.lint.jgit.errors.LargeObjectException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectLoader;
import com.netflix.nebula.lint.jgit.lib.ObjectReader;
import com.netflix.nebula.lint.jgit.lib.ObjectStream;
import com.netflix.nebula.lint.jgit.treewalk.TreeWalk;
import com.netflix.nebula.lint.jgit.treewalk.WorkingTreeIterator;
import com.netflix.nebula.lint.jgit.treewalk.filter.PathFilter;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public abstract class ContentSource {
    public static ContentSource create(ObjectReader reader) {
        return new ObjectReaderSource(reader);
    }

    public static ContentSource create(WorkingTreeIterator iterator) {
        return new WorkingTreeSource(iterator);
    }

    public abstract long size(String var1, ObjectId var2) throws IOException;

    public abstract ObjectLoader open(String var1, ObjectId var2) throws IOException;

    private static class ObjectReaderSource
    extends ContentSource {
        private final ObjectReader reader;

        ObjectReaderSource(ObjectReader reader) {
            this.reader = reader;
        }

        @Override
        public long size(String path, ObjectId id) throws IOException {
            try {
                return this.reader.getObjectSize(id, 3);
            }
            catch (MissingObjectException ignore) {
                return 0L;
            }
        }

        @Override
        public ObjectLoader open(String path, ObjectId id) throws IOException {
            return this.reader.open(id, 3);
        }
    }

    public static final class Pair {
        private final ContentSource oldSource;
        private final ContentSource newSource;

        public Pair(ContentSource oldSource, ContentSource newSource) {
            this.oldSource = oldSource;
            this.newSource = newSource;
        }

        public long size(DiffEntry.Side side, DiffEntry ent) throws IOException {
            switch (side) {
                case OLD: {
                    return this.oldSource.size(ent.oldPath, ent.oldId.toObjectId());
                }
                case NEW: {
                    return this.newSource.size(ent.newPath, ent.newId.toObjectId());
                }
            }
            throw new IllegalArgumentException();
        }

        public ObjectLoader open(DiffEntry.Side side, DiffEntry ent) throws IOException {
            switch (side) {
                case OLD: {
                    return this.oldSource.open(ent.oldPath, ent.oldId.toObjectId());
                }
                case NEW: {
                    return this.newSource.open(ent.newPath, ent.newId.toObjectId());
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private static class WorkingTreeSource
    extends ContentSource {
        private final TreeWalk tw = new TreeWalk(null);
        private final WorkingTreeIterator iterator;
        private String current;
        WorkingTreeIterator ptr;

        WorkingTreeSource(WorkingTreeIterator iterator) {
            this.tw.setRecursive(true);
            this.iterator = iterator;
        }

        @Override
        public long size(String path, ObjectId id) throws IOException {
            this.seek(path);
            return this.ptr.getEntryLength();
        }

        @Override
        public ObjectLoader open(String path, ObjectId id) throws IOException {
            this.seek(path);
            final long entrySize = this.ptr.getEntryContentLength();
            return new ObjectLoader(){

                @Override
                public long getSize() {
                    return entrySize;
                }

                @Override
                public int getType() {
                    return ptr.getEntryFileMode().getObjectType();
                }

                @Override
                public ObjectStream openStream() throws MissingObjectException, IOException {
                    long contentLength = entrySize;
                    InputStream in = ptr.openEntryStream();
                    in = new BufferedInputStream(in);
                    return new ObjectStream.Filter(this.getType(), contentLength, in);
                }

                @Override
                public boolean isLarge() {
                    return true;
                }

                @Override
                public byte[] getCachedBytes() throws LargeObjectException {
                    throw new LargeObjectException();
                }
            };
        }

        private void seek(String path) throws IOException {
            if (!path.equals(this.current)) {
                this.iterator.reset();
                this.tw.reset();
                this.tw.addTree(this.iterator);
                this.tw.setFilter(PathFilter.create(path));
                this.current = path;
                if (!this.tw.next()) {
                    throw new FileNotFoundException(path);
                }
                this.ptr = this.tw.getTree(0, WorkingTreeIterator.class);
                if (this.ptr == null) {
                    throw new FileNotFoundException(path);
                }
            }
        }
    }
}

