/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.AddNoteCommand;
import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.lib.ObjectInserter;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.notes.Note;
import com.netflix.nebula.lint.jgit.notes.NoteMap;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevObject;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import java.io.IOException;

public class RemoveNoteCommand
extends GitCommand<Note> {
    private RevObject id;
    private String notesRef = "refs/notes/commits";

    protected RemoveNoteCommand(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Note call() throws GitAPIException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                Note note;
                RevWalk walk = new RevWalk(this.repo);
                try {
                    block17: {
                        ObjectInserter inserter = this.repo.newObjectInserter();
                        try {
                            NoteMap map = NoteMap.newEmptyMap();
                            RevCommit notesCommit = null;
                            Ref ref = this.repo.exactRef(this.notesRef);
                            if (ref != null) {
                                notesCommit = walk.parseCommit(ref.getObjectId());
                                map = NoteMap.read(walk.getObjectReader(), notesCommit);
                            }
                            map.set(this.id, null, inserter);
                            AddNoteCommand.commitNoteMap(this.repo, this.notesRef, walk, map, notesCommit, inserter, "Notes removed by 'git notes remove'");
                            note = map.getNote(this.id);
                            return note;
                        }
                        finally {
                            if (inserter == null) break block17;
                            inserter.close();
                        }
                    }
                    if (walk != null) {
                        walk.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (walk == null) throw throwable;
                    walk.close();
                    throw throwable;
                }
                {
                    return note;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public RemoveNoteCommand setObjectId(RevObject id) {
        this.checkCallable();
        this.id = id;
        return this;
    }

    public RemoveNoteCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

