/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.IClassFile;
import com.netflix.nebula.lint.jdt.core.IMember;
import com.netflix.nebula.lint.jdt.core.ISourceRange;
import com.netflix.nebula.lint.jdt.core.ITypeParameter;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.internal.core.ClassFile;
import com.netflix.nebula.lint.jdt.internal.core.ClassFileInfo;
import com.netflix.nebula.lint.jdt.internal.core.JavaElement;
import com.netflix.nebula.lint.jdt.internal.core.JavaElementInfo;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelManager;
import com.netflix.nebula.lint.jdt.internal.core.Openable;
import com.netflix.nebula.lint.jdt.internal.core.SourceMapper;
import com.netflix.nebula.lint.jdt.internal.core.SourceRange;
import com.netflix.nebula.lint.jdt.internal.core.SourceRefElement;
import com.netflix.nebula.lint.jdt.internal.core.TypeParameterElementInfo;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;

public class TypeParameter
extends SourceRefElement
implements ITypeParameter {
    static final ITypeParameter[] NO_TYPE_PARAMETERS = new ITypeParameter[0];
    protected String name;

    public TypeParameter(JavaElement parent, String name) {
        super(parent);
        this.name = name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeParameter)) {
            return false;
        }
        return super.equals(o);
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws JavaModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent == null) {
            return;
        }
        JavaElementInfo openableParentInfo = (JavaElementInfo)JavaModelManager.getJavaModelManager().getInfo(openableParent);
        if (openableParentInfo == null) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
        if (openableParent.getElementType() == 6) {
            ClassFileInfo classFileInfo = (ClassFileInfo)(openableParentInfo == null ? newElements.get(openableParent) : openableParentInfo);
            if (classFileInfo == null) {
                return;
            }
            classFileInfo.getBinaryChildren(newElements);
        }
    }

    public String[] getBounds() throws JavaModelException {
        TypeParameterElementInfo info = (TypeParameterElementInfo)this.getElementInfo();
        return CharOperation.toStrings(info.bounds);
    }

    public IMember getDeclaringMember() {
        return (IMember)this.getParent();
    }

    public String getElementName() {
        return this.name;
    }

    public int getElementType() {
        return 15;
    }

    protected char getHandleMementoDelimiter() {
        return ']';
    }

    public ISourceRange getNameRange() throws JavaModelException {
        TypeParameterElementInfo info = (TypeParameterElementInfo)this.getElementInfo();
        return new SourceRange(info.nameStart, info.nameEnd - info.nameStart + 1);
    }

    public ISourceRange getSourceRange() throws JavaModelException {
        ClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = (ClassFile)this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getSourceRange(this);
        }
        return super.getSourceRange();
    }

    public IClassFile getClassFile() {
        return ((JavaElement)this.getParent()).getClassFile();
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append('<');
        buffer.append(this.getElementName());
        buffer.append('>');
    }
}

