/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.BindingKey;
import com.netflix.nebula.lint.jdt.core.ICompilationUnit;
import com.netflix.nebula.lint.jdt.core.IField;
import com.netflix.nebula.lint.jdt.core.IMember;
import com.netflix.nebula.lint.jdt.core.IMethod;
import com.netflix.nebula.lint.jdt.core.IPackageFragment;
import com.netflix.nebula.lint.jdt.core.IType;
import com.netflix.nebula.lint.jdt.core.ITypeParameter;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.Signature;
import com.netflix.nebula.lint.jdt.internal.core.JavaElement;
import com.netflix.nebula.lint.jdt.internal.core.Member;

public abstract class NamedMember
extends Member {
    protected String name;

    public NamedMember(JavaElement parent, String name) {
        super(parent);
        this.name = name;
    }

    private void appendTypeParameters(StringBuffer buffer) throws JavaModelException {
        ITypeParameter[] typeParameters = this.getTypeParameters();
        int length = typeParameters.length;
        if (length == 0) {
            return;
        }
        buffer.append('<');
        int i = 0;
        while (i < length) {
            ITypeParameter typeParameter = typeParameters[i];
            buffer.append(typeParameter.getElementName());
            String[] bounds = typeParameter.getBounds();
            int boundsLength = bounds.length;
            if (boundsLength > 0) {
                buffer.append(" extends ");
                int j = 0;
                while (j < boundsLength) {
                    buffer.append(bounds[j]);
                    if (j < boundsLength - 1) {
                        buffer.append(" & ");
                    }
                    ++j;
                }
            }
            if (i < length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append('>');
    }

    public String getElementName() {
        return this.name;
    }

    protected String getKey(IField field, boolean forceOpen) throws JavaModelException {
        StringBuffer key = new StringBuffer();
        String declaringKey = this.getKey((IType)field.getParent(), forceOpen);
        key.append(declaringKey);
        key.append('.');
        key.append(field.getElementName());
        return key.toString();
    }

    protected String getKey(IMethod method, boolean forceOpen) throws JavaModelException {
        StringBuffer key = new StringBuffer();
        String declaringKey = this.getKey((IType)method.getParent(), forceOpen);
        key.append(declaringKey);
        key.append('.');
        String selector = method.getElementName();
        key.append(selector);
        key.append('(');
        String[] parameters = method.getParameterTypes();
        int i = 0;
        int length = parameters.length;
        while (i < length) {
            key.append(parameters[i].replace('.', '/'));
            ++i;
        }
        key.append(')');
        if (forceOpen) {
            key.append(method.getReturnType());
        } else {
            key.append('V');
        }
        return key.toString();
    }

    protected String getKey(IType type, boolean forceOpen) throws JavaModelException {
        StringBuffer key = new StringBuffer();
        key.append('L');
        String packageName = type.getPackageFragment().getElementName();
        key.append(packageName.replace('.', '/'));
        if (packageName.length() > 0) {
            key.append('/');
        }
        String typeQualifiedName = type.getTypeQualifiedName('$');
        ICompilationUnit cu = (ICompilationUnit)type.getAncestor(5);
        if (cu != null) {
            String topLevelTypeName;
            String cuName = cu.getElementName();
            String mainTypeName = cuName.substring(0, cuName.lastIndexOf(46));
            int end = typeQualifiedName.indexOf(36);
            if (end == -1) {
                end = typeQualifiedName.length();
            }
            if (!mainTypeName.equals(topLevelTypeName = typeQualifiedName.substring(0, end))) {
                key.append(mainTypeName);
                key.append('~');
            }
        }
        key.append(typeQualifiedName);
        key.append(';');
        return key.toString();
    }

    protected String getFullyQualifiedParameterizedName(String fullyQualifiedName, String uniqueKey) throws JavaModelException {
        String[] typeArguments = new BindingKey(uniqueKey).getTypeArguments();
        int length = typeArguments.length;
        if (length == 0) {
            return fullyQualifiedName;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(fullyQualifiedName);
        buffer.append('<');
        int i = 0;
        while (i < length) {
            String typeArgument = typeArguments[i];
            typeArgument.replace('/', '.');
            buffer.append(Signature.toString(typeArgument));
            if (i < length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        buffer.append('>');
        return buffer.toString();
    }

    protected IPackageFragment getPackageFragment() {
        return null;
    }

    public String getFullyQualifiedName(char enclosingTypeSeparator, boolean showParameters) throws JavaModelException {
        String packageName = this.getPackageFragment().getElementName();
        if (packageName.equals("")) {
            return this.getTypeQualifiedName(enclosingTypeSeparator, showParameters);
        }
        return String.valueOf(packageName) + '.' + this.getTypeQualifiedName(enclosingTypeSeparator, showParameters);
    }

    public String getTypeQualifiedName(char enclosingTypeSeparator, boolean showParameters) throws JavaModelException {
        NamedMember declaringType;
        switch (this.parent.getElementType()) {
            case 5: {
                if (showParameters) {
                    StringBuffer buffer = new StringBuffer(this.name);
                    this.appendTypeParameters(buffer);
                    return buffer.toString();
                }
                return this.name;
            }
            case 6: {
                String classFileName = this.parent.getElementName();
                String typeName = classFileName.indexOf(36) == -1 ? this.name : classFileName.substring(0, classFileName.lastIndexOf(46));
                if (showParameters) {
                    StringBuffer buffer = new StringBuffer(typeName);
                    this.appendTypeParameters(buffer);
                    return buffer.toString();
                }
                return typeName;
            }
            case 7: {
                declaringType = (NamedMember)this.parent;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                declaringType = (NamedMember)((Object)((IMember)((Object)this.parent)).getDeclaringType());
                break;
            }
            default: {
                return null;
            }
        }
        StringBuffer buffer = new StringBuffer(declaringType.getTypeQualifiedName(enclosingTypeSeparator, showParameters));
        buffer.append(enclosingTypeSeparator);
        String simpleName = this.name.length() == 0 ? Integer.toString(this.occurrenceCount) : this.name;
        buffer.append(simpleName);
        if (showParameters) {
            this.appendTypeParameters(buffer);
        }
        return buffer.toString();
    }

    protected ITypeParameter[] getTypeParameters() throws JavaModelException {
        return null;
    }
}

