/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.problem;

import com.netflix.nebula.lint.jdt.core.compiler.IProblem;
import com.netflix.nebula.lint.jdt.internal.compiler.CompilationResult;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.InvocationSite;
import com.netflix.nebula.lint.jdt.internal.compiler.problem.ProblemHandler;

public class AbortCompilation
extends RuntimeException {
    public CompilationResult compilationResult;
    public Throwable exception;
    public IProblem problem;
    public boolean isSilent;
    public RuntimeException silentException;
    private static final long serialVersionUID = -2047226595083244852L;

    public AbortCompilation() {
    }

    public AbortCompilation(CompilationResult compilationResult, IProblem problem) {
        this();
        this.compilationResult = compilationResult;
        this.problem = problem;
    }

    public AbortCompilation(CompilationResult compilationResult, Throwable exception) {
        this();
        this.compilationResult = compilationResult;
        this.exception = exception;
    }

    public AbortCompilation(boolean isSilent, RuntimeException silentException) {
        this();
        this.isSilent = isSilent;
        this.silentException = silentException;
    }

    public void updateContext(InvocationSite invocationSite, CompilationResult unitResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(invocationSite.sourceStart());
        this.problem.setSourceEnd(invocationSite.sourceEnd());
        this.problem.setSourceLineNumber(ProblemHandler.searchLineNumber(unitResult.lineSeparatorPositions, invocationSite.sourceStart()));
        this.compilationResult = unitResult;
    }

    public void updateContext(ASTNode astNode, CompilationResult unitResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(astNode.sourceStart());
        this.problem.setSourceEnd(astNode.sourceEnd());
        this.problem.setSourceLineNumber(ProblemHandler.searchLineNumber(unitResult.lineSeparatorPositions, astNode.sourceStart()));
        this.compilationResult = unitResult;
    }
}

