/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.parser;

import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.compiler.InvalidInputException;
import com.netflix.nebula.lint.jdt.internal.compiler.parser.Parser;
import com.netflix.nebula.lint.jdt.internal.compiler.parser.Scanner;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCommentParser {
    public static final char[] TAG_DEPRECATED = "deprecated".toCharArray();
    public static final char[] TAG_PARAM = "param".toCharArray();
    public static final char[] TAG_RETURN = "return".toCharArray();
    public static final char[] TAG_THROWS = "throws".toCharArray();
    public static final char[] TAG_EXCEPTION = "exception".toCharArray();
    public static final char[] TAG_SEE = "see".toCharArray();
    public static final char[] TAG_LINK = "link".toCharArray();
    public static final char[] TAG_LINKPLAIN = "linkplain".toCharArray();
    public static final char[] TAG_INHERITDOC = "inheritDoc".toCharArray();
    public static final char[] TAG_VALUE = "value".toCharArray();
    public static final int NO_TAG_VALUE = 0;
    public static final int TAG_DEPRECATED_VALUE = 1;
    public static final int TAG_PARAM_VALUE = 2;
    public static final int TAG_RETURN_VALUE = 3;
    public static final int TAG_THROWS_VALUE = 4;
    public static final int TAG_EXCEPTION_VALUE = 5;
    public static final int TAG_SEE_VALUE = 6;
    public static final int TAG_LINK_VALUE = 7;
    public static final int TAG_LINKPLAIN_VALUE = 8;
    public static final int TAG_INHERITDOC_VALUE = 9;
    public static final int TAG_VALUE_VALUE = 10;
    public static final int TAG_OTHERS_VALUE = 11;
    protected int tagValue = 0;
    public static final int ORDERED_TAGS_NUMBER = 3;
    public static final int PARAM_TAG_EXPECTED_ORDER = 0;
    public static final int THROWS_TAG_EXPECTED_ORDER = 1;
    public static final int SEE_TAG_EXPECTED_ORDER = 2;
    public static final int COMPIL_PARSER = 1;
    public static final int DOM_PARSER = 2;
    public static final int SELECTION_PARSER = 3;
    public Scanner scanner;
    public char[] source;
    protected Parser sourceParser;
    private int currentTokenType = -1;
    public boolean checkDocComment = false;
    public boolean reportProblems;
    protected boolean jdk15;
    protected long inheritedPositions;
    protected boolean deprecated;
    protected Object returnStatement;
    protected int javadocStart;
    protected int javadocEnd;
    protected int firstTagPosition;
    protected int index;
    protected int lineEnd;
    protected int tokenPreviousPosition;
    protected int lastIdentifierEndPosition;
    protected int starPosition;
    protected int textStart;
    protected int memberStart;
    protected int tagSourceStart;
    protected int tagSourceEnd;
    protected int inlineTagStart;
    protected int[] lineEnds;
    protected boolean lineStarted = false;
    protected boolean inlineTagStarted = false;
    protected boolean abort = false;
    protected int kind;
    private int linePtr;
    private int lastLinePtr;
    protected int identifierPtr;
    protected char[][] identifierStack;
    protected int identifierLengthPtr;
    protected int[] identifierLengthStack;
    protected long[] identifierPositionStack;
    protected static int AstStackIncrement = 10;
    protected int astPtr;
    protected Object[] astStack;
    protected int astLengthPtr;
    protected int[] astLengthStack;

    protected AbstractCommentParser(Parser sourceParser) {
        this.sourceParser = sourceParser;
        this.scanner = new Scanner(false, false, false, 0x2F0000L, null, null, true);
        this.identifierStack = new char[20][];
        this.identifierPositionStack = new long[20];
        this.identifierLengthStack = new int[10];
        this.astStack = new Object[30];
        this.astLengthStack = new int[20];
        this.reportProblems = sourceParser != null;
    }

    protected boolean commentParse() {
        boolean validComment = true;
        try {
            int end;
            int realStart;
            this.linePtr = this.getLineNumber(this.firstTagPosition);
            int n = realStart = this.linePtr == 1 ? this.javadocStart : this.scanner.getLineEnd(this.linePtr - 1) + 1;
            if (realStart < this.javadocStart) {
                realStart = this.javadocStart;
            }
            this.scanner.resetTo(realStart, this.javadocEnd);
            this.index = realStart;
            if (realStart == this.javadocStart) {
                this.readChar();
                this.readChar();
            }
            int previousPosition = this.index;
            int nextCharacter = 0;
            if (realStart == this.javadocStart) {
                nextCharacter = this.readChar();
            }
            this.astLengthPtr = -1;
            this.astPtr = -1;
            this.currentTokenType = -1;
            this.inlineTagStarted = false;
            this.inlineTagStart = -1;
            this.lineStarted = false;
            this.returnStatement = null;
            this.inheritedPositions = -1L;
            this.deprecated = false;
            this.lastLinePtr = this.getLineNumber(this.javadocEnd);
            this.lineEnd = this.linePtr == this.lastLinePtr ? this.javadocEnd : this.scanner.getLineEnd(this.linePtr) - 1;
            this.textStart = -1;
            int previousChar = 0;
            int invalidTagLineEnd = -1;
            int invalidInlineTagLineEnd = -1;
            block15: while (!this.abort && this.index < this.javadocEnd) {
                previousPosition = this.index;
                previousChar = nextCharacter;
                if (this.index > this.lineEnd + 1) {
                    this.updateLineEnd();
                }
                if (this.currentTokenType < 0) {
                    nextCharacter = this.readChar();
                } else {
                    previousPosition = this.scanner.getCurrentTokenStartPosition();
                    switch (this.currentTokenType) {
                        case 31: {
                            nextCharacter = 125;
                            break;
                        }
                        case 4: {
                            nextCharacter = 42;
                            break;
                        }
                        default: {
                            nextCharacter = this.scanner.currentCharacter;
                        }
                    }
                    this.consumeToken();
                }
                if (this.index >= this.javadocEnd) break;
                switch (nextCharacter) {
                    case 64: {
                        if (!this.lineStarted || previousChar == 123) {
                            this.lineStarted = true;
                            if (this.inlineTagStarted) {
                                this.inlineTagStarted = false;
                                if (this.reportProblems) {
                                    end = previousPosition < invalidInlineTagLineEnd ? previousPosition : invalidInlineTagLineEnd;
                                    this.sourceParser.problemReporter().javadocUnterminatedInlineTag(this.inlineTagStart, end);
                                }
                                validComment = false;
                                if (this.lineStarted && this.textStart != -1 && this.textStart < previousPosition && this.kind == 2) {
                                    this.pushText(this.textStart, previousPosition);
                                }
                                if (this.kind == 2) {
                                    this.refreshInlineTagPosition(previousPosition);
                                }
                            }
                            if (previousChar == 123) {
                                if (this.textStart != -1 && this.textStart < this.inlineTagStart && this.kind == 2) {
                                    this.pushText(this.textStart, this.inlineTagStart);
                                }
                                this.inlineTagStarted = true;
                                invalidInlineTagLineEnd = this.lineEnd;
                            } else if (this.textStart != -1 && this.textStart < invalidTagLineEnd && this.kind == 2) {
                                this.pushText(this.textStart, invalidTagLineEnd);
                            }
                            this.scanner.resetTo(this.index, this.javadocEnd);
                            this.currentTokenType = -1;
                            try {
                                if (this.parseTag(previousPosition)) continue block15;
                                validComment = false;
                                if (this.kind != 2) continue block15;
                                this.createTag();
                                this.textStart = this.tagSourceEnd + 1;
                                invalidTagLineEnd = this.lineEnd;
                            }
                            catch (InvalidInputException invalidInputException) {
                                this.consumeToken();
                            }
                            continue block15;
                        }
                        if (this.kind != 1 || this.tagValue != 3 || this.returnStatement == null) continue block15;
                        this.refreshReturnStatement();
                        break;
                    }
                    case 10: 
                    case 13: {
                        if (this.lineStarted && this.textStart < previousPosition && this.kind == 2) {
                            this.pushText(this.textStart, previousPosition);
                        }
                        this.lineStarted = false;
                        this.textStart = -1;
                        break;
                    }
                    case 125: {
                        if (this.kind == 1 && this.tagValue == 3 && this.returnStatement != null) {
                            this.refreshReturnStatement();
                        }
                        if (this.inlineTagStarted) {
                            if (this.kind == 2) {
                                if (this.lineStarted && this.textStart != -1 && this.textStart < previousPosition) {
                                    this.pushText(this.textStart, previousPosition);
                                }
                                this.refreshInlineTagPosition(previousPosition);
                            }
                            this.textStart = this.index;
                            this.inlineTagStarted = false;
                        } else if (!this.lineStarted) {
                            this.textStart = previousPosition;
                        }
                        this.lineStarted = true;
                        break;
                    }
                    case 123: {
                        if (this.kind == 1 && this.tagValue == 3 && this.returnStatement != null) {
                            this.refreshReturnStatement();
                        }
                        if (this.inlineTagStarted) {
                            this.inlineTagStarted = false;
                            if (this.reportProblems) {
                                end = previousPosition < invalidInlineTagLineEnd ? previousPosition : invalidInlineTagLineEnd;
                                this.sourceParser.problemReporter().javadocUnterminatedInlineTag(this.inlineTagStart, end);
                            }
                            if (this.kind == 2) {
                                if (this.lineStarted && this.textStart != -1 && this.textStart < previousPosition) {
                                    this.pushText(this.textStart, previousPosition);
                                }
                                this.refreshInlineTagPosition(previousPosition);
                            }
                        }
                        if (!this.lineStarted) {
                            this.textStart = previousPosition;
                        }
                        this.lineStarted = true;
                        this.inlineTagStart = previousPosition;
                        break;
                    }
                    case 9: 
                    case 12: 
                    case 32: 
                    case 42: {
                        break;
                    }
                    default: {
                        if (this.kind == 1 && this.tagValue == 3 && this.returnStatement != null) {
                            this.refreshReturnStatement();
                        }
                        if (!this.lineStarted) {
                            this.textStart = previousPosition;
                        }
                        this.lineStarted = true;
                    }
                }
            }
            if (this.inlineTagStarted) {
                this.inlineTagStarted = false;
                if (this.reportProblems) {
                    int n2 = end = previousPosition < invalidInlineTagLineEnd ? previousPosition : invalidInlineTagLineEnd;
                    if (this.index >= this.javadocEnd) {
                        end = invalidInlineTagLineEnd;
                    }
                    this.sourceParser.problemReporter().javadocUnterminatedInlineTag(this.inlineTagStart, end);
                }
                if (this.kind == 2) {
                    if (this.lineStarted && this.textStart != -1 && this.textStart < previousPosition) {
                        this.pushText(this.textStart, previousPosition);
                    }
                    this.refreshInlineTagPosition(previousPosition);
                }
            } else if (this.kind == 2 && this.lineStarted && this.textStart < previousPosition) {
                this.pushText(this.textStart, previousPosition);
            }
            this.updateDocComment();
        }
        catch (Exception exception) {
            validComment = false;
        }
        return validComment;
    }

    private void consumeToken() {
        this.currentTokenType = -1;
        this.updateLineEnd();
    }

    protected abstract Object createArgumentReference(char[] var1, int var2, boolean var3, Object var4, long[] var5, long var6) throws InvalidInputException;

    protected abstract Object createFieldReference(Object var1) throws InvalidInputException;

    protected abstract Object createMethodReference(Object var1, List var2) throws InvalidInputException;

    protected Object createReturnStatement() {
        return null;
    }

    protected abstract void createTag();

    protected abstract Object createTypeReference(int var1);

    private int getIndexPosition() {
        if (this.index > this.lineEnd) {
            return this.lineEnd;
        }
        return this.index - 1;
    }

    private int getLineNumber(int position) {
        if (this.scanner.linePtr != -1) {
            return this.scanner.getLineNumber(position);
        }
        if (this.lineEnds == null) {
            return 1;
        }
        int length = this.lineEnds.length;
        if (length == 0) {
            return 1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = (g + d) / 2;
            if (position < this.lineEnds[m]) {
                d = m - 1;
                continue;
            }
            if (position > this.lineEnds[m]) {
                g = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < this.lineEnds[m]) {
            return m + 1;
        }
        return m + 2;
    }

    private int getTokenEndPosition() {
        if (this.scanner.getCurrentTokenEndPosition() > this.lineEnd) {
            return this.lineEnd;
        }
        return this.scanner.getCurrentTokenEndPosition();
    }

    private Object parseArguments(Object receiver) throws InvalidInputException {
        int modulo = 0;
        int iToken = 0;
        char[] argName = null;
        ArrayList<Object> arguments = new ArrayList<Object>(10);
        int start = this.scanner.getCurrentTokenStartPosition();
        block2: while (this.index < this.scanner.eofPosition) {
            Object argument;
            char[] name;
            boolean firstArg;
            Object typeRef;
            try {
                typeRef = this.parseQualifiedName(false);
                if (this.abort) {
                    return null;
                }
            }
            catch (InvalidInputException invalidInputException) {
                break;
            }
            boolean bl = firstArg = modulo == 0;
            if (!firstArg ? iToken % modulo != 0 : iToken != 0) break;
            if (typeRef == null) {
                if (!firstArg || this.currentTokenType != 29) break;
                if (!this.verifySpaceOrEndComment()) {
                    int end;
                    int n = end = this.starPosition == -1 ? this.lineEnd : this.starPosition;
                    if (this.source[end] == '\n') {
                        --end;
                    }
                    if (this.reportProblems) {
                        this.sourceParser.problemReporter().javadocMalformedSeeReference(start, end);
                    }
                    return null;
                }
                this.lineStarted = true;
                return this.createMethodReference(receiver, null);
            }
            ++iToken;
            int dim = 0;
            boolean isVarargs = false;
            long[] dimPositions = new long[20];
            if (this.readToken() == 14) {
                int dimStart = this.scanner.getCurrentTokenStartPosition();
                while (this.readToken() == 14) {
                    this.consumeToken();
                    if (this.readToken() != 70) break block2;
                    this.consumeToken();
                    dimPositions[dim++] = ((long)dimStart << 32) + (long)this.scanner.getCurrentTokenEndPosition();
                }
            } else if (this.readToken() == 107) {
                int dimStart = this.scanner.getCurrentTokenStartPosition();
                dimPositions[dim++] = ((long)dimStart << 32) + (long)this.scanner.getCurrentTokenEndPosition();
                this.consumeToken();
                isVarargs = true;
            }
            long argNamePos = -1L;
            if (this.readToken() == 26) {
                this.consumeToken();
                if (!firstArg ? iToken % modulo != 1 : iToken != 1) break;
                if (argName == null && !firstArg) break;
                argName = this.scanner.getCurrentIdentifierSource();
                argNamePos = ((long)this.scanner.getCurrentTokenStartPosition() << 32) + (long)this.scanner.getCurrentTokenEndPosition();
                ++iToken;
            } else if (argName != null) break;
            if (firstArg) {
                modulo = iToken + 1;
            } else if (iToken % modulo != modulo - 1) break;
            int token = this.readToken();
            char[] cArray = name = argName == null ? new char[]{} : argName;
            if (token == 30) {
                argument = this.createArgumentReference(name, dim, isVarargs, typeRef, dimPositions, argNamePos);
                if (this.abort) {
                    return null;
                }
                arguments.add(argument);
                this.consumeToken();
                ++iToken;
                continue;
            }
            if (token != 29) break;
            if (!this.verifySpaceOrEndComment()) {
                int end;
                int n = end = this.starPosition == -1 ? this.lineEnd : this.starPosition;
                if (this.source[end] == '\n') {
                    --end;
                }
                if (this.reportProblems) {
                    this.sourceParser.problemReporter().javadocMalformedSeeReference(start, end);
                }
                return null;
            }
            argument = this.createArgumentReference(name, dim, isVarargs, typeRef, dimPositions, argNamePos);
            if (this.abort) {
                return null;
            }
            arguments.add(argument);
            this.consumeToken();
            return this.createMethodReference(receiver, arguments);
        }
        throw new InvalidInputException();
    }

    private boolean parseHref() throws InvalidInputException {
        int start = this.scanner.getCurrentTokenStartPosition();
        if (Character.toLowerCase(this.readChar()) == 'a') {
            this.scanner.currentPosition = this.index;
            if (this.readToken() == 26) {
                this.consumeToken();
                try {
                    if (CharOperation.equals(this.scanner.getCurrentIdentifierSource(), new char[]{'h', 'r', 'e', 'f'}, false) && this.readToken() == 71) {
                        this.consumeToken();
                        if (this.readToken() == 52) {
                            this.consumeToken();
                            while (this.readToken() != 12) {
                                if (this.scanner.currentPosition >= this.scanner.eofPosition || this.scanner.currentCharacter == '@' || this.inlineTagStarted && this.scanner.currentCharacter == '}') {
                                    this.index = this.tokenPreviousPosition;
                                    this.scanner.currentPosition = this.tokenPreviousPosition;
                                    this.currentTokenType = -1;
                                    if (this.tagValue != 10 && this.reportProblems) {
                                        this.sourceParser.problemReporter().javadocInvalidSeeUrlReference(start, this.lineEnd);
                                    }
                                    return false;
                                }
                                this.currentTokenType = -1;
                            }
                            if (this.currentTokenType == 12) {
                                this.consumeToken();
                                while (this.readToken() != 7) {
                                    if (this.scanner.currentPosition >= this.scanner.eofPosition || this.scanner.currentCharacter == '@' || this.inlineTagStarted && this.scanner.currentCharacter == '}') {
                                        this.index = this.tokenPreviousPosition;
                                        this.scanner.currentPosition = this.tokenPreviousPosition;
                                        this.currentTokenType = -1;
                                        if (this.tagValue != 10 && this.reportProblems) {
                                            this.sourceParser.problemReporter().javadocInvalidSeeUrlReference(start, this.lineEnd);
                                        }
                                        return false;
                                    }
                                    this.consumeToken();
                                }
                                this.consumeToken();
                                start = this.scanner.getCurrentTokenStartPosition();
                                if (this.readChar() == '/' && Character.toLowerCase(this.readChar()) == 'a' && this.readChar() == '>') {
                                    return true;
                                }
                            }
                        }
                    }
                }
                catch (InvalidInputException invalidInputException) {}
            }
        }
        this.index = this.tokenPreviousPosition;
        this.scanner.currentPosition = this.tokenPreviousPosition;
        this.currentTokenType = -1;
        if (this.tagValue != 10 && this.reportProblems) {
            this.sourceParser.problemReporter().javadocInvalidSeeUrlReference(start, this.lineEnd);
        }
        return false;
    }

    private Object parseMember(Object receiver) throws InvalidInputException {
        int start;
        this.identifierPtr = -1;
        this.identifierLengthPtr = -1;
        this.memberStart = start = this.scanner.getCurrentTokenStartPosition();
        if (this.readToken() == 26) {
            this.consumeToken();
            this.pushIdentifier(true);
            int previousPosition = this.index;
            if (this.readToken() == 28) {
                this.consumeToken();
                start = this.scanner.getCurrentTokenStartPosition();
                try {
                    return this.parseArguments(receiver);
                }
                catch (InvalidInputException invalidInputException) {
                    int end = this.scanner.getCurrentTokenEndPosition() < this.lineEnd ? this.scanner.getCurrentTokenEndPosition() : this.scanner.getCurrentTokenStartPosition();
                    int n = end = end < this.lineEnd ? end : this.lineEnd;
                    if (this.reportProblems) {
                        this.sourceParser.problemReporter().javadocInvalidSeeReferenceArgs(start, end);
                    }
                    return null;
                }
            }
            this.index = previousPosition;
            this.scanner.currentPosition = previousPosition;
            this.currentTokenType = -1;
            if (!this.verifySpaceOrEndComment()) {
                int end;
                int n = end = this.starPosition == -1 ? this.lineEnd : this.starPosition;
                if (this.source[end] == '\n') {
                    --end;
                }
                if (this.reportProblems) {
                    this.sourceParser.problemReporter().javadocMalformedSeeReference(start, end);
                }
                return null;
            }
            return this.createFieldReference(receiver);
        }
        int end = this.getTokenEndPosition() - 1;
        int n = end = start > end ? start : end;
        if (this.reportProblems) {
            this.sourceParser.problemReporter().javadocInvalidReference(start, end);
        }
        this.index = this.tokenPreviousPosition;
        this.scanner.currentPosition = this.tokenPreviousPosition;
        this.currentTokenType = -1;
        return null;
    }

    protected boolean parseParam() throws InvalidInputException {
        int start = this.tagSourceStart;
        int end = this.tagSourceEnd;
        boolean tokenWhiteSpace = this.scanner.tokenizeWhiteSpace;
        this.scanner.tokenizeWhiteSpace = true;
        int token = this.readToken();
        if (token != 1000) {
            if (this.reportProblems) {
                this.sourceParser.problemReporter().javadocInvalidTag(start, this.scanner.getCurrentTokenEndPosition());
            }
            this.scanner.currentPosition = start;
            this.index = start;
            this.currentTokenType = -1;
            this.scanner.tokenizeWhiteSpace = tokenWhiteSpace;
            return false;
        }
        this.identifierPtr = -1;
        this.identifierLengthPtr = -1;
        boolean hasMultiLines = this.scanner.currentPosition > this.lineEnd + 1;
        boolean isTypeParam = false;
        boolean valid = true;
        boolean empty = true;
        block24: while (true) {
            this.currentTokenType = -1;
            try {
                token = this.readToken();
            }
            catch (InvalidInputException invalidInputException) {
                valid = false;
            }
            switch (token) {
                case 26: {
                    if (valid) {
                        this.pushIdentifier(true);
                        start = this.scanner.getCurrentTokenStartPosition();
                        end = hasMultiLines ? this.lineEnd : this.scanner.getCurrentTokenEndPosition();
                        break block24;
                    }
                }
                case 7: {
                    if (valid && this.jdk15) {
                        this.pushIdentifier(true);
                        start = this.scanner.getCurrentTokenStartPosition();
                        end = hasMultiLines ? this.lineEnd : this.scanner.getCurrentTokenEndPosition();
                        isTypeParam = true;
                        break block24;
                    }
                }
                default: {
                    if (token == 13) {
                        isTypeParam = true;
                    }
                    if (valid && !hasMultiLines) {
                        start = this.scanner.getCurrentTokenStartPosition();
                    }
                    valid = false;
                    if (!hasMultiLines) {
                        empty = false;
                        end = hasMultiLines ? this.lineEnd : this.scanner.getCurrentTokenEndPosition();
                        break;
                    }
                    end = this.lineEnd;
                }
                case 1000: {
                    if (this.scanner.currentPosition > this.lineEnd + 1) {
                        hasMultiLines = true;
                    }
                    if (valid) continue block24;
                }
                case 66: {
                    if (this.reportProblems) {
                        if (empty) {
                            this.sourceParser.problemReporter().javadocMissingParamName(start, end, this.sourceParser.modifiers);
                        } else if (this.jdk15 && isTypeParam) {
                            this.sourceParser.problemReporter().javadocInvalidParamTypeParameter(start, end);
                        } else {
                            this.sourceParser.problemReporter().javadocInvalidParamTagName(start, end);
                        }
                    }
                    this.scanner.currentPosition = start;
                    this.index = start;
                    this.currentTokenType = -1;
                    this.scanner.tokenizeWhiteSpace = tokenWhiteSpace;
                    return false;
                }
            }
        }
        if (isTypeParam && this.jdk15) {
            block25: while (true) {
                this.currentTokenType = -1;
                try {
                    token = this.readToken();
                }
                catch (InvalidInputException invalidInputException) {
                    valid = false;
                }
                switch (token) {
                    case 1000: {
                        if (valid && this.scanner.currentPosition <= this.lineEnd + 1) continue block25;
                    }
                    case 66: {
                        if (this.reportProblems) {
                            this.sourceParser.problemReporter().javadocInvalidParamTypeParameter(start, end);
                        }
                        this.scanner.currentPosition = start;
                        this.index = start;
                        this.currentTokenType = -1;
                        this.scanner.tokenizeWhiteSpace = tokenWhiteSpace;
                        return false;
                    }
                    case 26: {
                        int n = end = hasMultiLines ? this.lineEnd : this.scanner.getCurrentTokenEndPosition();
                        if (!valid) continue block25;
                        this.pushIdentifier(false);
                        break block25;
                    }
                    default: {
                        end = hasMultiLines ? this.lineEnd : this.scanner.getCurrentTokenEndPosition();
                        valid = false;
                    }
                }
            }
            boolean spaces = false;
            block26: while (true) {
                this.currentTokenType = -1;
                try {
                    token = this.readToken();
                }
                catch (InvalidInputException invalidInputException) {
                    valid = false;
                }
                switch (token) {
                    case 1000: {
                        if (this.scanner.currentPosition > this.lineEnd + 1) {
                            hasMultiLines = true;
                            valid = false;
                        }
                        spaces = true;
                        if (valid) continue block26;
                    }
                    case 66: {
                        if (this.reportProblems) {
                            this.sourceParser.problemReporter().javadocInvalidParamTypeParameter(start, end);
                        }
                        this.scanner.currentPosition = start;
                        this.index = start;
                        this.currentTokenType = -1;
                        this.scanner.tokenizeWhiteSpace = tokenWhiteSpace;
                        return false;
                    }
                    case 12: {
                        int n = end = hasMultiLines ? this.lineEnd : this.scanner.getCurrentTokenEndPosition();
                        if (!valid) continue block26;
                        this.pushIdentifier(false);
                        break block26;
                    }
                    default: {
                        if (!spaces) {
                            end = hasMultiLines ? this.lineEnd : this.scanner.getCurrentTokenEndPosition();
                        }
                        valid = false;
                    }
                }
            }
        }
        if (valid) {
            this.currentTokenType = -1;
            int restart = this.scanner.currentPosition;
            try {
                token = this.readToken();
            }
            catch (InvalidInputException invalidInputException) {
                valid = false;
            }
            if (token == 1000) {
                this.scanner.currentPosition = restart;
                this.index = restart;
                this.scanner.tokenizeWhiteSpace = tokenWhiteSpace;
                return this.pushParamName(isTypeParam);
            }
        }
        this.currentTokenType = -1;
        end = hasMultiLines ? this.lineEnd : this.scanner.getCurrentTokenEndPosition();
        while ((token = this.readToken()) != 1000 && token != 66) {
            this.currentTokenType = -1;
            end = hasMultiLines ? this.lineEnd : this.scanner.getCurrentTokenEndPosition();
        }
        if (this.reportProblems) {
            if (this.jdk15 && isTypeParam) {
                this.sourceParser.problemReporter().javadocInvalidParamTypeParameter(start, end);
            } else {
                this.sourceParser.problemReporter().javadocInvalidParamTagName(start, end);
            }
        }
        this.scanner.currentPosition = start;
        this.index = start;
        this.currentTokenType = -1;
        this.scanner.tokenizeWhiteSpace = tokenWhiteSpace;
        return false;
    }

    protected Object parseQualifiedName(boolean reset) throws InvalidInputException {
        if (reset) {
            this.identifierPtr = -1;
            this.identifierLengthPtr = -1;
        }
        int primitiveToken = -1;
        int iToken = 0;
        block5: while (true) {
            int token = this.readTokenSafely();
            switch (token) {
                case 26: {
                    if (iToken % 2 > 0) break block5;
                    this.pushIdentifier(iToken == 0);
                    this.consumeToken();
                    break;
                }
                case 3: {
                    if (iToken % 2 == 0) {
                        throw new InvalidInputException();
                    }
                    this.consumeToken();
                    break;
                }
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    if (iToken > 0) {
                        throw new InvalidInputException();
                    }
                    this.pushIdentifier(true);
                    primitiveToken = token;
                    this.consumeToken();
                    break block5;
                }
                default: {
                    if (iToken == 0) {
                        return null;
                    }
                    if (iToken % 2 != 0) break block5;
                    if (this.kind == 2 && this.currentTokenType != -1) {
                        this.index = this.tokenPreviousPosition;
                        this.scanner.currentPosition = this.tokenPreviousPosition;
                        this.currentTokenType = -1;
                    }
                    throw new InvalidInputException();
                }
            }
            ++iToken;
        }
        if (this.currentTokenType != -1) {
            this.index = this.tokenPreviousPosition;
            this.scanner.currentPosition = this.tokenPreviousPosition;
            this.currentTokenType = -1;
        }
        this.lastIdentifierEndPosition = (int)this.identifierPositionStack[this.identifierPtr];
        return this.createTypeReference(primitiveToken);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parseReference() throws InvalidInputException {
        currentPosition = this.scanner.currentPosition;
        try {
            typeRef = null;
            reference = null;
            previousPosition = -1;
            typeRefStartPosition = -1;
            block8: while (this.index < this.scanner.eofPosition) {
                previousPosition = this.index;
                token = this.readTokenSafely();
                switch (token) {
                    case 52: {
                        if (typeRef != null) break block8;
                        this.consumeToken();
                        start = this.scanner.getCurrentTokenStartPosition();
                        if (this.tagValue == 10) {
                            if (this.reportProblems) {
                                this.sourceParser.problemReporter().javadocInvalidValueReference(start, this.getTokenEndPosition(), this.sourceParser.modifiers);
                            }
                            return false;
                        }
                        if (typeRef != null) {
                            previousPosition = start = this.tagSourceEnd + 1;
                            typeRef = null;
                        }
                        if (this.verifyEndLine(previousPosition)) {
                            return true;
                        }
                        if (this.reportProblems) {
                            this.sourceParser.problemReporter().javadocUnexpectedText(this.scanner.currentPosition, this.lineEnd);
                        }
                        return false;
                    }
                    case 7: {
                        if (typeRef != null) break block8;
                        this.consumeToken();
                        start = this.scanner.getCurrentTokenStartPosition();
                        if (this.parseHref()) {
                            this.consumeToken();
                            if (typeRef != null) {
                                previousPosition = start = this.tagSourceEnd + 1;
                                typeRef = null;
                            }
                            if (this.tagValue == 10) {
                                if (this.reportProblems) {
                                    this.sourceParser.problemReporter().javadocInvalidValueReference(start, this.getIndexPosition(), this.sourceParser.modifiers);
                                }
                                return false;
                            }
                            if (this.verifyEndLine(previousPosition)) {
                                return true;
                            }
                            if (this.reportProblems) {
                                this.sourceParser.problemReporter().javadocUnexpectedText(this.scanner.currentPosition, this.lineEnd);
                            }
                        } else if (this.tagValue == 10 && this.reportProblems) {
                            this.sourceParser.problemReporter().javadocInvalidValueReference(start, this.getIndexPosition(), this.sourceParser.modifiers);
                        }
                        return false;
                    }
                    case 110: {
                        if (this.scanner.currentCharacter == '#') {
                            this.consumeToken();
                            reference = this.parseMember(typeRef);
                            if (reference != null) {
                                return this.pushSeeRef(reference);
                            }
                            return false;
                        }
                        currentError = this.scanner.getCurrentIdentifierSource();
                        if (currentError.length <= 0 || currentError[0] != '\"') break block8;
                        if (this.reportProblems) {
                            this.sourceParser.problemReporter().javadocInvalidReference(this.scanner.getCurrentTokenStartPosition(), this.getTokenEndPosition());
                        }
                        return false;
                    }
                    case 26: {
                        if (typeRef == null) {
                            typeRefStartPosition = this.scanner.getCurrentTokenStartPosition();
                            typeRef = this.parseQualifiedName(true);
                            if (!this.abort) continue block8;
                            return false;
                        } else {
                            ** GOTO lbl66
                        }
                    }
                }
            }
lbl66:
            // 7 sources

            if (reference == null) {
                reference = typeRef;
            }
            if (reference == null) {
                this.index = this.tokenPreviousPosition;
                this.scanner.currentPosition = this.tokenPreviousPosition;
                this.currentTokenType = -1;
                if (this.tagValue == 10) {
                    if (this.kind == 2) {
                        this.createTag();
                    }
                    return true;
                }
                if (this.reportProblems) {
                    this.sourceParser.problemReporter().javadocMissingReference(this.tagSourceStart, this.tagSourceEnd, this.sourceParser.modifiers);
                }
                return false;
            }
            this.scanner.currentPosition = this.index = this.lastIdentifierEndPosition + 1;
            this.currentTokenType = -1;
            if (this.tagValue == 10) {
                if (this.reportProblems) {
                    this.sourceParser.problemReporter().javadocInvalidReference(typeRefStartPosition, this.lineEnd);
                }
                return false;
            }
            ch = this.peekChar();
            if (ch == '(') {
                if (this.reportProblems) {
                    this.sourceParser.problemReporter().javadocMissingHashCharacter(typeRefStartPosition, this.lineEnd, String.valueOf(this.source, typeRefStartPosition, this.lineEnd - typeRefStartPosition + 1));
                }
                return false;
            }
            if (!this.verifySpaceOrEndComment()) {
                this.index = this.tokenPreviousPosition;
                this.scanner.currentPosition = this.tokenPreviousPosition;
                this.currentTokenType = -1;
                v0 = end = this.starPosition == -1 ? this.lineEnd : this.starPosition;
                if (this.source[end] == '\n') {
                    --end;
                }
                if (this.reportProblems) {
                    this.sourceParser.problemReporter().javadocMalformedSeeReference(typeRefStartPosition, end);
                }
                return false;
            }
            return this.pushSeeRef(reference);
        }
        catch (InvalidInputException v1) {
            if (this.reportProblems) {
                this.sourceParser.problemReporter().javadocInvalidReference(currentPosition, this.getTokenEndPosition());
            }
            this.index = this.tokenPreviousPosition;
            this.scanner.currentPosition = this.tokenPreviousPosition;
            this.currentTokenType = -1;
            return false;
        }
    }

    protected abstract boolean parseTag(int var1) throws InvalidInputException;

    protected boolean parseThrows() {
        block5: {
            int start = this.scanner.currentPosition;
            try {
                Object typeRef = this.parseQualifiedName(true);
                if (this.abort) {
                    return false;
                }
                if (typeRef == null) {
                    if (this.reportProblems) {
                        this.sourceParser.problemReporter().javadocMissingThrowsClassName(this.tagSourceStart, this.tagSourceEnd, this.sourceParser.modifiers);
                    }
                    break block5;
                }
                return this.pushThrowName(typeRef);
            }
            catch (InvalidInputException invalidInputException) {
                if (!this.reportProblems) break block5;
                this.sourceParser.problemReporter().javadocInvalidThrowsClass(start, this.getTokenEndPosition());
            }
        }
        return false;
    }

    protected char peekChar() {
        char c;
        int idx = this.index;
        if ((c = this.source[idx++]) == '\\' && this.source[idx] == 'u') {
            int c4;
            int c3;
            int c2;
            int c1;
            ++idx;
            while (this.source[idx] == 'u') {
                ++idx;
            }
            if ((c1 = Character.getNumericValue(this.source[idx++])) <= 15 && c1 >= 0 && (c2 = Character.getNumericValue(this.source[idx++])) <= 15 && c2 >= 0 && (c3 = Character.getNumericValue(this.source[idx++])) <= 15 && c3 >= 0 && (c4 = Character.getNumericValue(this.source[idx++])) <= 15 && c4 >= 0) {
                c = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
            }
        }
        return c;
    }

    protected void pushIdentifier(boolean newLength) {
        int stackLength = this.identifierStack.length;
        if (++this.identifierPtr >= stackLength) {
            this.identifierStack = new char[stackLength + 10][];
            System.arraycopy(this.identifierStack, 0, this.identifierStack, 0, stackLength);
            this.identifierPositionStack = new long[stackLength + 10];
            System.arraycopy(this.identifierPositionStack, 0, this.identifierPositionStack, 0, stackLength);
        }
        this.identifierStack[this.identifierPtr] = this.scanner.getCurrentIdentifierSource();
        this.identifierPositionStack[this.identifierPtr] = ((long)this.scanner.startPosition << 32) + (long)(this.scanner.currentPosition - 1);
        if (newLength) {
            stackLength = this.identifierLengthStack.length;
            if (++this.identifierLengthPtr >= stackLength) {
                this.identifierLengthStack = new int[stackLength + 10];
                System.arraycopy(this.identifierLengthStack, 0, this.identifierLengthStack, 0, stackLength);
            }
            this.identifierLengthStack[this.identifierLengthPtr] = 1;
        } else {
            int n = this.identifierLengthPtr;
            this.identifierLengthStack[n] = this.identifierLengthStack[n] + 1;
        }
    }

    protected void pushOnAstStack(Object node, boolean newLength) {
        if (node == null) {
            this.astLengthStack[++this.astLengthPtr] = 0;
            return;
        }
        int stackLength = this.astStack.length;
        if (++this.astPtr >= stackLength) {
            this.astStack = new Object[stackLength + AstStackIncrement];
            System.arraycopy(this.astStack, 0, this.astStack, 0, stackLength);
            this.astPtr = stackLength;
        }
        this.astStack[this.astPtr] = node;
        if (newLength) {
            stackLength = this.astLengthStack.length;
            if (++this.astLengthPtr >= stackLength) {
                this.astLengthStack = new int[stackLength + AstStackIncrement];
                System.arraycopy(this.astLengthStack, 0, this.astLengthStack, 0, stackLength);
            }
            this.astLengthStack[this.astLengthPtr] = 1;
        } else {
            int n = this.astLengthPtr;
            this.astLengthStack[n] = this.astLengthStack[n] + 1;
        }
    }

    protected abstract boolean pushParamName(boolean var1);

    protected abstract boolean pushSeeRef(Object var1);

    protected void pushText(int start, int end) {
    }

    protected abstract boolean pushThrowName(Object var1);

    protected char readChar() {
        char c;
        if ((c = this.source[this.index++]) == '\\' && this.source[this.index] == 'u') {
            int c4;
            int c3;
            int c2;
            int c1;
            int pos = this.index++;
            while (this.source[this.index] == 'u') {
                ++this.index;
            }
            if ((c1 = Character.getNumericValue(this.source[this.index++])) <= 15 && c1 >= 0 && (c2 = Character.getNumericValue(this.source[this.index++])) <= 15 && c2 >= 0 && (c3 = Character.getNumericValue(this.source[this.index++])) <= 15 && c3 >= 0 && (c4 = Character.getNumericValue(this.source[this.index++])) <= 15 && c4 >= 0) {
                c = (char)(((c1 * 16 + c2) * 16 + c3) * 16 + c4);
            } else {
                this.index = pos;
            }
        }
        return c;
    }

    protected int readToken() throws InvalidInputException {
        if (this.currentTokenType < 0) {
            this.tokenPreviousPosition = this.scanner.currentPosition;
            this.currentTokenType = this.scanner.getNextToken();
            if (this.scanner.currentPosition > this.lineEnd + 1) {
                this.lineStarted = false;
                while (this.currentTokenType == 4) {
                    this.currentTokenType = this.scanner.getNextToken();
                }
            }
            this.index = this.scanner.currentPosition;
            this.lineStarted = true;
        }
        return this.currentTokenType;
    }

    protected int readTokenAndConsume() throws InvalidInputException {
        int token = this.readToken();
        this.consumeToken();
        return token;
    }

    protected int readTokenSafely() {
        int token = 110;
        try {
            token = this.readToken();
        }
        catch (InvalidInputException invalidInputException) {}
        return token;
    }

    protected void refreshInlineTagPosition(int previousPosition) {
    }

    protected void refreshReturnStatement() {
    }

    public String toString() {
        char[] middle;
        int endPos;
        StringBuffer buffer = new StringBuffer();
        int startPos = this.scanner.currentPosition < this.index ? this.scanner.currentPosition : this.index;
        int n = endPos = this.scanner.currentPosition < this.index ? this.index : this.scanner.currentPosition;
        if (startPos == this.source.length) {
            return "EOF\n\n" + new String(this.source);
        }
        if (endPos > this.source.length) {
            return "behind the EOF\n\n" + new String(this.source);
        }
        char[] front = new char[startPos];
        System.arraycopy(this.source, 0, front, 0, startPos);
        int middleLength = endPos - 1 - startPos + 1;
        if (middleLength > -1) {
            middle = new char[middleLength];
            System.arraycopy(this.source, startPos, middle, 0, middleLength);
        } else {
            middle = CharOperation.NO_CHAR;
        }
        char[] end = new char[this.source.length - (endPos - 1)];
        System.arraycopy(this.source, endPos - 1 + 1, end, 0, this.source.length - (endPos - 1) - 1);
        buffer.append(front);
        if (this.scanner.currentPosition < this.index) {
            buffer.append("\n===============================\nScanner current position here -->");
        } else {
            buffer.append("\n===============================\nParser index here -->");
        }
        buffer.append(middle);
        if (this.scanner.currentPosition < this.index) {
            buffer.append("<-- Parser index here\n===============================\n");
        } else {
            buffer.append("<-- Scanner current position here\n===============================\n");
        }
        buffer.append(end);
        return buffer.toString();
    }

    protected abstract void updateDocComment();

    protected void updateLineEnd() {
        while (this.index > this.lineEnd + 1) {
            if (this.linePtr < this.lastLinePtr) {
                this.lineEnd = this.scanner.getLineEnd(++this.linePtr) - 1;
                continue;
            }
            this.lineEnd = this.javadocEnd;
            return;
        }
    }

    private boolean verifyEndLine(int textPosition) {
        if (this.inlineTagStarted) {
            if (this.peekChar() == '}') {
                if (this.kind == 2) {
                    this.createTag();
                    this.pushText(textPosition, this.starPosition);
                }
                return true;
            }
            return false;
        }
        int startPosition = this.index;
        int previousPosition = this.index;
        this.starPosition = -1;
        char ch = this.readChar();
        block6: while (true) {
            switch (ch) {
                case '\n': 
                case '\r': {
                    if (this.kind == 2) {
                        this.createTag();
                        this.pushText(textPosition, previousPosition);
                    }
                    this.index = previousPosition;
                    return true;
                }
                case '\t': 
                case '\f': 
                case ' ': {
                    if (this.starPosition < 0) break;
                    break block6;
                }
                case '*': {
                    this.starPosition = previousPosition;
                    break;
                }
                case '/': {
                    if (this.starPosition >= textPosition) {
                        if (this.kind == 2) {
                            this.createTag();
                            this.pushText(textPosition, this.starPosition);
                        }
                        return true;
                    }
                }
                default: {
                    break block6;
                }
            }
            previousPosition = this.index;
            ch = this.readChar();
        }
        this.index = startPosition;
        return false;
    }

    private boolean verifySpaceOrEndComment() {
        int startPosition = this.index;
        char ch = this.peekChar();
        switch (ch) {
            case '}': {
                return this.inlineTagStarted;
            }
        }
        if (Character.isWhitespace(ch)) {
            return true;
        }
        int previousPosition = this.index;
        this.starPosition = -1;
        ch = this.readChar();
        while (this.index < this.source.length) {
            switch (ch) {
                case '*': {
                    this.starPosition = previousPosition;
                    break;
                }
                case '/': {
                    if (this.starPosition >= startPosition) {
                        return true;
                    }
                }
                default: {
                    this.index = startPosition;
                    return false;
                }
            }
            previousPosition = this.index;
            ch = this.readChar();
        }
        this.index = startPosition;
        return false;
    }
}

