/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.ast;

import com.netflix.nebula.lint.jdt.internal.compiler.ASTVisitor;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.OperatorExpression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeReference;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.CodeStream;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowContext;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.Scope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;

public class InstanceOfExpression
extends OperatorExpression {
    public Expression expression;
    public TypeReference type;

    public InstanceOfExpression(Expression expression, TypeReference type, int operator) {
        this.expression = expression;
        this.type = type;
        this.bits |= operator << 6;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = type.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        this.expression.checkNullStatus(currentScope, flowContext, flowInfo, -1);
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        this.expression.generateCode(currentScope, codeStream, true);
        codeStream.instance_of(this.type.resolvedType);
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.expression.printExpression(indent, output).append(" instanceof ");
        return this.type.print(0, output);
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = NotAConstant;
        TypeBinding expressionType = this.expression.resolveType(scope);
        TypeBinding checkedType = this.type.resolveType(scope, true);
        if (expressionType == null || checkedType == null) {
            return null;
        }
        if (!checkedType.isReifiable()) {
            scope.problemReporter().illegalInstanceOfGenericType(checkedType, this);
        } else {
            boolean isLegal = this.checkCastTypesCompatibility(scope, checkedType, expressionType, null);
            if (!isLegal) {
                scope.problemReporter().notCompatibleTypesError(this, expressionType, checkedType);
            }
        }
        this.resolvedType = BooleanBinding;
        return this.resolvedType;
    }

    public void tagAsUnnecessaryCast(Scope scope, TypeBinding castType) {
        if (this.expression.resolvedType != NullBinding) {
            scope.problemReporter().unnecessaryInstanceof(this, castType);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
            this.type.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

