/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.ast;

import com.netflix.nebula.lint.jdt.internal.compiler.ASTVisitor;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.FieldReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.PostfixExpression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.QualifiedNameReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.QualifiedThisReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Reference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.SingleNameReference;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.CodeStream;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowContext;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BaseTypeBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.Binding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.FieldBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.LocalVariableBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.WildcardBinding;

public class Assignment
extends Expression {
    public Expression lhs;
    public Expression expression;

    public Assignment(Expression lhs, Expression expression, int sourceEnd) {
        this.lhs = lhs;
        lhs.bits |= 0x2000;
        this.expression = expression;
        this.sourceStart = lhs.sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        LocalVariableBinding local = this.lhs.localVariableBinding();
        int nullStatus = this.expression.nullStatus(flowInfo);
        if (local != null && nullStatus == 1) {
            flowContext.recordUsingNullReference(currentScope, local, this.lhs, -1, flowInfo);
        }
        flowInfo = ((Reference)this.lhs).analyseAssignment(currentScope, flowContext, flowInfo, this, false).unconditionalInits();
        if (local != null) {
            switch (nullStatus) {
                case 1: {
                    flowInfo.markAsDefinitelyNull(local);
                    break;
                }
                case -1: {
                    flowInfo.markAsDefinitelyNonNull(local);
                }
            }
        }
        return flowInfo;
    }

    void checkAssignmentEffect(BlockScope scope) {
        Binding left = this.getDirectBinding(this.lhs);
        if (left != null && left == this.getDirectBinding(this.expression)) {
            scope.problemReporter().assignmentHasNoEffect(this, left.shortReadableName());
            this.bits |= 0x20000000;
        }
    }

    void checkAssignment(BlockScope scope, TypeBinding lhsType, TypeBinding rhsType) {
        FieldBinding leftField = this.getLastField(this.lhs);
        if (leftField != null && rhsType != NullBinding && lhsType.isWildcard() && ((WildcardBinding)lhsType).boundKind != 2) {
            scope.problemReporter().wildcardAssignment(lhsType, rhsType, this.expression);
        } else if (leftField != null && leftField.declaringClass != null && leftField.declaringClass.isRawType()) {
            scope.problemReporter().unsafeRawFieldAssignment(leftField, rhsType, this.lhs);
        } else if (rhsType.needsUncheckedConversion(lhsType)) {
            scope.problemReporter().unsafeTypeConversion(this.expression, rhsType, lhsType);
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if ((this.bits & 0x20000000) != 0) {
            if (valueRequired) {
                this.expression.generateCode(currentScope, codeStream, true);
            }
        } else {
            ((Reference)this.lhs).generateAssignment(currentScope, codeStream, this, valueRequired);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    Binding getDirectBinding(Expression someExpression) {
        if (someExpression instanceof SingleNameReference) {
            return ((SingleNameReference)someExpression).binding;
        }
        if (someExpression instanceof FieldReference) {
            FieldReference fieldRef = (FieldReference)someExpression;
            if (fieldRef.receiver.isThis() && !(fieldRef.receiver instanceof QualifiedThisReference)) {
                return fieldRef.binding;
            }
        } else if (someExpression instanceof PostfixExpression) {
            return this.getDirectBinding(((PostfixExpression)someExpression).lhs);
        }
        return null;
    }

    FieldBinding getLastField(Expression someExpression) {
        if (someExpression instanceof SingleNameReference) {
            if ((someExpression.bits & 7) == 1) {
                return (FieldBinding)((SingleNameReference)someExpression).binding;
            }
        } else {
            if (someExpression instanceof FieldReference) {
                return ((FieldReference)someExpression).binding;
            }
            if (someExpression instanceof QualifiedNameReference) {
                QualifiedNameReference qName = (QualifiedNameReference)someExpression;
                if (qName.otherBindings == null && (someExpression.bits & 7) == 1) {
                    return (FieldBinding)qName.binding;
                }
                return qName.otherBindings[qName.otherBindings.length - 1];
            }
        }
        return null;
    }

    public int nullStatus(FlowInfo flowInfo) {
        return this.expression.nullStatus(flowInfo);
    }

    public StringBuffer print(int indent, StringBuffer output) {
        Assignment.printIndent(indent, output);
        return this.printExpressionNoParenthesis(indent, output);
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('(');
        return this.printExpressionNoParenthesis(0, output).append(')');
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.lhs.printExpression(indent, output).append(" = ");
        return this.expression.printExpression(0, output);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        return this.print(indent, output).append(';');
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = NotAConstant;
        if (!(this.lhs instanceof Reference) || this.lhs.isThis()) {
            scope.problemReporter().expressionShouldBeAVariable(this.lhs);
            return null;
        }
        TypeBinding lhsType = this.lhs.resolveType(scope);
        this.expression.setExpectedType(lhsType);
        if (lhsType != null) {
            this.resolvedType = lhsType.capture(scope, this.sourceEnd);
        }
        TypeBinding rhsType = this.expression.resolveType(scope);
        if (lhsType == null || rhsType == null) {
            return null;
        }
        this.checkAssignmentEffect(scope);
        if (lhsType != rhsType) {
            scope.compilationUnitScope().recordTypeConversion(lhsType, rhsType);
        }
        if (this.expression.isConstantValueOfTypeAssignableToType(rhsType, lhsType) || lhsType.isBaseType() && BaseTypeBinding.isWidening(lhsType.id, rhsType.id) || rhsType.isCompatibleWith(lhsType)) {
            this.expression.computeConversion(scope, lhsType, rhsType);
            this.checkAssignment(scope, lhsType, rhsType);
            return this.resolvedType;
        }
        if (scope.isBoxingCompatibleWith(rhsType, lhsType) || rhsType.isBaseType() && scope.compilerOptions().sourceLevel >= 0x310000L && !lhsType.isBaseType() && this.expression.isConstantValueOfTypeAssignableToType(rhsType, scope.environment().computeBoxingType(lhsType))) {
            this.expression.computeConversion(scope, lhsType, rhsType);
            return this.resolvedType;
        }
        scope.problemReporter().typeMismatchError(rhsType, lhsType, this.expression);
        return lhsType;
    }

    public TypeBinding resolveTypeExpecting(BlockScope scope, TypeBinding expectedType) {
        TypeBinding type = super.resolveTypeExpecting(scope, expectedType);
        if (type == null) {
            return null;
        }
        TypeBinding lhsType = this.resolvedType;
        TypeBinding rhsType = this.expression.resolvedType;
        if (expectedType == BooleanBinding && lhsType == BooleanBinding && (this.lhs.bits & 0x2000) != 0) {
            scope.problemReporter().possibleAccidentalBooleanAssignment(this);
        }
        this.checkAssignment(scope, lhsType, rhsType);
        return type;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.lhs.traverse(visitor, scope);
            this.expression.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

