/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.metacat.client.module;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netflix.metacat.common.exception.MetacatAlreadyExistsException;
import com.netflix.metacat.common.exception.MetacatBadRequestException;
import com.netflix.metacat.common.exception.MetacatException;
import com.netflix.metacat.common.exception.MetacatNotFoundException;
import com.netflix.metacat.common.exception.MetacatNotSupportedException;
import com.netflix.metacat.common.json.MetacatJson;
import com.netflix.metacat.common.json.MetacatJsonException;
import com.netflix.metacat.common.json.MetacatJsonLocator;
import feign.Response;
import feign.RetryableException;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.Reader;
import javax.ws.rs.core.Response;

public class MetacatErrorDecoder
extends ErrorDecoder.Default {
    private static final MetacatJson METACAT_JSON = MetacatJsonLocator.INSTANCE;

    public Exception decode(String methodKey, Response response) {
        try {
            String message = "";
            if (response.body() != null) {
                message = Util.toString((Reader)response.body().asReader());
                try {
                    ObjectNode body = METACAT_JSON.parseJsonObject(message);
                    message = body.path("error").asText();
                }
                catch (MetacatJsonException metacatJsonException) {
                    // empty catch block
                }
            }
            switch (response.status()) {
                case 415: 
                case 501: {
                    return new MetacatNotSupportedException(message);
                }
                case 400: {
                    return new MetacatBadRequestException(message);
                }
                case 404: {
                    return new MetacatNotFoundException(message);
                }
                case 409: {
                    return new MetacatAlreadyExistsException(message);
                }
                case 500: 
                case 503: {
                    return new RetryableException(message, null);
                }
            }
            return new MetacatException(message, Response.Status.INTERNAL_SERVER_ERROR, null);
        }
        catch (IOException e) {
            return super.decode(methodKey, response);
        }
    }
}

