/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.metacat.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import com.google.common.base.Preconditions;
import com.netflix.metacat.client.module.JacksonDecoder;
import com.netflix.metacat.client.module.JacksonEncoder;
import com.netflix.metacat.client.module.MetacatErrorDecoder;
import com.netflix.metacat.common.api.MetacatV1;
import com.netflix.metacat.common.api.MetadataV1;
import com.netflix.metacat.common.api.PartitionV1;
import com.netflix.metacat.common.json.MetacatJsonLocator;
import feign.Contract;
import feign.Feign;
import feign.Logger;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jaxrs.JAXRSContract;
import feign.slf4j.Slf4jLogger;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private final MetacatV1 api;
    private final Feign.Builder feignBuilder;
    private final String host;
    private final PartitionV1 partitionApi;
    private final MetadataV1 metadataApi;

    private Client(@Nonnull String host, @Nonnull Logger.Level logLevel, @Nonnull RequestInterceptor requestInterceptor, @Nonnull Retryer retryer, @Nonnull Request.Options options) {
        ObjectMapper mapper = MetacatJsonLocator.INSTANCE.getPrettyObjectMapper().copy().registerModule((Module)new GuavaModule()).registerModule((Module)new JaxbAnnotationModule());
        log.info("Connecting to {}", (Object)host);
        this.host = host;
        this.feignBuilder = Feign.builder().logger((feign.Logger)new Slf4jLogger()).logLevel(logLevel).contract((Contract)new JAXRSContract()).encoder((Encoder)new JacksonEncoder(mapper)).decoder((Decoder)new JacksonDecoder(mapper)).errorDecoder((ErrorDecoder)new MetacatErrorDecoder()).requestInterceptor(requestInterceptor).retryer(retryer).options(options);
        this.api = this.getApiClient(MetacatV1.class);
        this.partitionApi = this.getApiClient(PartitionV1.class);
        this.metadataApi = this.getApiClient(MetadataV1.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T getApiClient(@Nonnull Class<T> apiType) {
        Preconditions.checkArgument((boolean)apiType.isInterface(), (Object)"apiType must be an interface");
        return (T)this.feignBuilder.target(apiType, this.host);
    }

    public MetacatV1 getApi() {
        return this.api;
    }

    public PartitionV1 getPartitionApi() {
        return this.partitionApi;
    }

    public MetadataV1 getMetadataApi() {
        return this.metadataApi;
    }

    public static class Builder {
        private String host;
        private String userName;
        private String clientAppName;
        private String jobId;
        private String dataTypeContext;
        private Logger.Level logLevel;
        private Retryer retryer;
        private RequestInterceptor requestInterceptor;
        private Request.Options requestOptions;

        public Builder withLogLevel(Logger.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withRetryer(Retryer retryer) {
            this.retryer = retryer;
            return this;
        }

        public Builder withUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder withClientAppName(String appName) {
            this.clientAppName = appName;
            return this;
        }

        public Builder withJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder withDataTypeContext(String dataTypeContext) {
            this.dataTypeContext = dataTypeContext;
            return this;
        }

        public Builder withRequestInterceptor(RequestInterceptor requestInterceptor) {
            this.requestInterceptor = requestInterceptor;
            return this;
        }

        public Builder withRequestOptions(Request.Options requestOptions) {
            this.requestOptions = requestOptions;
            return this;
        }

        public Client build() {
            Preconditions.checkArgument((this.userName != null ? 1 : 0) != 0, (Object)"User name cannot be null");
            Preconditions.checkArgument((this.clientAppName != null ? 1 : 0) != 0, (Object)"Client application name cannot be null");
            if (this.host == null) {
                this.host = System.getProperty("netflix.metacat.host", System.getenv("NETFLIX_METACAT_HOST"));
            }
            Preconditions.checkArgument((this.host != null ? 1 : 0) != 0, (Object)"Host cannot be null");
            if (this.retryer == null) {
                this.retryer = new Retryer.Default(TimeUnit.MINUTES.toMillis(30L), TimeUnit.MINUTES.toMillis(30L), 0);
            }
            RequestInterceptor interceptor = new RequestInterceptor(){

                public void apply(RequestTemplate template) {
                    if (Builder.this.requestInterceptor != null) {
                        Builder.this.requestInterceptor.apply(template);
                    }
                    template.header("X-Netflix.user.name", new String[]{Builder.this.userName});
                    template.header("X-Netflix.client.app.name", new String[]{Builder.this.clientAppName});
                    template.header("X-Netflix.job.id", new String[]{Builder.this.jobId});
                    template.header("X-Netflix.data.type.context", new String[]{Builder.this.dataTypeContext});
                }
            };
            if (this.requestOptions == null) {
                this.requestOptions = new Request.Options((int)TimeUnit.MINUTES.toMillis(10L), (int)TimeUnit.MINUTES.toMillis(30L));
            }
            if (this.logLevel == null) {
                this.logLevel = Logger.Level.NONE;
            }
            return new Client(this.host, this.logLevel, interceptor, this.retryer, this.requestOptions);
        }
    }
}

