/*
 * Decompiled with CFR 0.152.
 */
package netflix.admin;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.netflix.explorers.ExplorerManager;
import com.netflix.explorers.context.GlobalModelContext;
import com.netflix.explorers.context.RequestContext;
import com.netflix.explorers.providers.ToJsonMethod;
import com.sun.jersey.api.view.Viewable;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import netflix.admin.AdminExplorerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminFreemarkerTemplateProvider
implements MessageBodyWriter<Viewable> {
    private static final Logger LOG = LoggerFactory.getLogger(AdminFreemarkerTemplateProvider.class);
    private static final String ADMIN_CONSOLE_LAYOUT = "bootstrap";
    private Configuration fmConfig = new Configuration();
    private ExplorerManager manager;
    @Context
    private ThreadLocal<HttpServletRequest> requestInvoker;

    @Inject
    public AdminFreemarkerTemplateProvider(AdminExplorerManager adminExplorerManager) {
        this.manager = adminExplorerManager;
    }

    @PostConstruct
    public void commonConstruct() {
        this.fmConfig.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(new TemplateLoader[]{new ClassTemplateLoader(this.getClass(), "/")}));
        this.fmConfig.setNumberFormat("0");
        this.fmConfig.setLocalizedLookup(false);
        this.fmConfig.setTemplateUpdateDelay(0);
        try {
            if (this.manager != null) {
                this.fmConfig.setSharedVariable("Global", (Object)this.manager.getGlobalModel());
                this.fmConfig.setSharedVariable("Explorers", (Object)this.manager);
            }
            this.fmConfig.setSharedVariable("toJson", (TemplateModel)new ToJsonMethod());
        }
        catch (TemplateModelException e) {
            throw new RuntimeException(e);
        }
    }

    public long getSize(Viewable t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return (mediaType.isCompatible(MediaType.TEXT_HTML_TYPE) || mediaType.isCompatible(MediaType.APPLICATION_XHTML_XML_TYPE)) && Viewable.class.isAssignableFrom(type);
    }

    public void writeTo(Viewable viewable, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream out) throws IOException, WebApplicationException {
        String username;
        HashMap<String, Object> vars;
        String resolvedPath = viewable.getTemplateName();
        Object model = viewable.getModel();
        LOG.debug("Evaluating freemarker template (" + resolvedPath + ") with model of type " + (model == null ? "null" : model.getClass().getSimpleName()));
        if (model instanceof Map) {
            vars = new HashMap((Map)model);
        } else {
            vars = new HashMap<String, Object>();
            vars.put("it", model);
        }
        RequestContext requestContext = new RequestContext();
        requestContext.setHttpServletRequest(this.requestInvoker != null ? this.requestInvoker.get() : null);
        vars.put("RequestContext", requestContext);
        vars.put("Request", this.requestInvoker != null ? this.requestInvoker.get() : null);
        Principal ctx = null;
        if (this.requestInvoker.get() != null && (ctx = this.requestInvoker.get().getUserPrincipal()) == null && this.requestInvoker.get().getSession(false) != null && (username = (String)this.requestInvoker.get().getSession().getAttribute("SSO_UserName")) != null) {
            ctx = new Principal(){

                @Override
                public String getName() {
                    return username;
                }
            };
        }
        vars.put("Principal", ctx);
        HashMap global = Maps.newHashMap();
        if (this.manager != null) {
            GlobalModelContext globalModel = this.manager.getGlobalModel();
            global.put("sysenv", globalModel.getEnvironment());
            vars.put("Explorer", this.manager.getExplorer("baseserver"));
        }
        vars.put("global", global);
        vars.put("pathToRoot", requestContext.getPathToRoot());
        StringWriter stringWriter = new StringWriter();
        try {
            if (requestContext.getIsAjaxRequest()) {
                this.fmConfig.getTemplate(resolvedPath).process(vars, (Writer)stringWriter);
            } else {
                vars.put("nestedpage", resolvedPath);
                this.fmConfig.getTemplate("/layout/bootstrap/main.ftl").process(vars, (Writer)stringWriter);
            }
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(stringWriter.getBuffer().toString());
            writer.flush();
        }
        catch (Throwable t) {
            LOG.error("Error processing freemarker template @ " + resolvedPath + ": " + t.getMessage(), t);
            throw new WebApplicationException(t, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

