/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources;

import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.spi.container.servlet.WebConfig;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
class AdminResourcesFilter
extends GuiceContainer {
    private final Map<String, HttpServlet> servlets = Maps.newConcurrentMap();
    private volatile String packages;

    @Inject
    AdminResourcesFilter(Injector injector) {
        super(injector);
    }

    void setPackages(String packages) {
        this.packages = packages;
    }

    void mapServlet(String path, HttpServlet servlet) {
        this.servlets.put(path, servlet);
    }

    public int service(URI baseUri, URI requestUri, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path;
        String string = path = requestUri != null ? requestUri.getPath() : null;
        if (path != null) {
            for (Map.Entry<String, HttpServlet> entry : this.servlets.entrySet()) {
                if (!path.startsWith(entry.getKey())) continue;
                entry.getValue().service((ServletRequest)request, (ServletResponse)response);
                return 200;
            }
        }
        return super.service(baseUri, requestUri, request, response);
    }

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig webConfig) throws ServletException {
        props.put("com.sun.jersey.config.property.packages", this.packages);
        return new PackagesResourceConfig(props);
    }
}

