/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.adminresources.resources;

import com.google.common.annotations.Beta;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.netflix.adminresources.resources.MaskedResourceHelper;
import com.netflix.adminresources.resources.PairResponse;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/webadmin/env")
@Produces(value={"application/json"})
@Beta
public class EnvironmentResource {
    @GET
    public Response getAllProperties() {
        HashMap<String, String> envVarsMap = new HashMap<String, String>(System.getenv());
        Set<String> maskedResources = MaskedResourceHelper.getMaskedResourceSet();
        for (String maskedResource : maskedResources) {
            if (!envVarsMap.containsKey(maskedResource)) continue;
            envVarsMap.put(maskedResource, "**** MASKED ****");
        }
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        Gson gson = gsonBuilder.create();
        String propsJson = gson.toJson((Object)new PairResponse(envVarsMap));
        return Response.ok((Object)propsJson).build();
    }
}

